/*
 * Decompiled with CFR 0.152.
 */
package cn.wenet.networkcomponent.okhttp.intercepter;

import android.text.TextUtils;
import android.util.Log;
import cn.wenet.networkcomponent.debug.WeDebug;
import cn.wenet.networkcomponent.okhttp.intercepter.BaseInterceptor;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;

public class BaseLogInterceptor
extends BaseInterceptor
implements Interceptor {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (WeDebug.DEBUG) {
            Response response;
            ResponseBody responseBody;
            Headers headers;
            RequestBody body;
            String method;
            String url;
            HttpUrl httpUrl = request.url();
            List strings = httpUrl.encodedPathSegments();
            if (null != strings && strings.size() > 0) {
                Log.e((String)"WANG", (String)("BaseLogInterceptor.intercept" + strings));
            }
            if (null != httpUrl && null != httpUrl.toString() && !TextUtils.isEmpty((CharSequence)(url = httpUrl.toString()))) {
                WeDebug.e("URL is : " + url);
            }
            if (!TextUtils.isEmpty((CharSequence)(method = request.method()))) {
                WeDebug.e("Method is : " + method);
            }
            if (null != (body = request.body())) {
                String bodyStr = body.toString();
                WeDebug.e("RequestBody is :" + bodyStr);
            }
            if (WeDebug.LOG_REQUEST_HEADER && null != (headers = request.headers())) {
                String headerStr = headers.toString();
                WeDebug.e("Headers is :" + headerStr);
            }
            if (null != (responseBody = (response = chain.proceed(request)).body())) {
                long contentLength;
                BufferedSource source = responseBody.source();
                source.request(Long.MAX_VALUE);
                Buffer buffer = source.buffer();
                MediaType contentType = responseBody.contentType();
                Charset charset = UTF8;
                if (null != contentType) {
                    charset = contentType.charset(UTF8);
                }
                if (0L != (contentLength = responseBody.contentLength())) {
                    String json = buffer.clone().readString(charset);
                    WeDebug.e("Json :" + json);
                }
            }
            return response;
        }
        return chain.proceed(request);
    }

    @Override
    public boolean isNetInterceptor() {
        return true;
    }
}

