/*
 * Decompiled with CFR 0.152.
 */
package cn.wenet.networkcomponent.okhttp;

import android.support.annotation.NonNull;
import cn.wenet.networkcomponent.okhttp.SSLSocketClient;
import cn.wenet.networkcomponent.okhttp.intercepter.BaseInterceptor;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class NetOkHttp {
    private OkHttpClient mOkHttpClient = null;
    private OkHttpClient.Builder builder;
    private volatile boolean haveChange = false;
    private ArrayList<Interceptor> mBaseInterceptors = new ArrayList();

    public static NetOkHttp getInstance() {
        return new NetOkHttp();
    }

    private NetOkHttp() {
        this.init();
    }

    public OkHttpClient getOkHttpClient() {
        this.emptyBuild();
        if (null == this.mOkHttpClient || this.haveChange) {
            this.mOkHttpClient = this.builder.build();
        }
        this.haveChange = false;
        return this.mOkHttpClient;
    }

    public void init() {
        SSLSocketFactory sslSocketFactory = SSLSocketClient.getSSLSocketFactory(SSLSocketClient.UnSafeTrustManager);
        this.builder = new OkHttpClient.Builder();
        this.builder.connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).sslSocketFactory(sslSocketFactory, SSLSocketClient.UnSafeTrustManager).hostnameVerifier(SSLSocketClient.UnSafeHostnameVerifier);
        this.change();
    }

    public void addBaseInterceptor(@NonNull BaseInterceptor interceptor) {
        this.emptyBuild();
        if (!this.mBaseInterceptors.contains(interceptor)) {
            this.mBaseInterceptors.add(interceptor);
            if (interceptor.isNetInterceptor()) {
                this.builder.addNetworkInterceptor((Interceptor)interceptor);
            } else {
                this.builder.addInterceptor((Interceptor)interceptor);
            }
            this.change();
        }
    }

    private void emptyBuild() {
        if (null == this.builder) {
            throw new NullPointerException("NetOkHttp.mOkHttpClient.Builder  is null !");
        }
    }

    public boolean isHaveChange() {
        return this.haveChange;
    }

    private void change() {
        this.haveChange = true;
    }
}

