/*
 * Decompiled with CFR 0.152.
 */
package cn.wenet.networkcomponent.base;

import cn.wenet.networkcomponent.base.NetBaseResultBean;
import cn.wenet.networkcomponent.base.NetLifecycleControl;
import cn.wenet.networkcomponent.exception.NetException;
import cn.wenet.networkcomponent.request.WeNetworkCallBack;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

public class NetBaseObserver<T>
implements Observer<T> {
    private WeNetworkCallBack netCallBack;
    private NetLifecycleControl mTag;

    public void setNetCallBack(WeNetworkCallBack netCallBack) {
        this.netCallBack = netCallBack;
    }

    public void setTag(NetLifecycleControl mTag) {
        this.mTag = mTag;
    }

    public void onError(Throwable e) {
        NetException netException = new NetException(e);
        this.netCallBack.onError(netException);
    }

    public void onComplete() {
    }

    public void onSubscribe(Disposable d) {
        if (null != this.mTag) {
            this.mTag.addDisposable(d);
        }
    }

    public void onNext(T t) {
        if (null == this.netCallBack) {
            return;
        }
        if (t instanceof NetBaseResultBean) {
            NetBaseResultBean resultBean = (NetBaseResultBean)t;
            NetException netException = new NetException(resultBean.getCode(), resultBean.getStatus(), resultBean.getMsg());
            boolean success = netException.success();
            if (success) {
                Object data = resultBean.getData();
                if (null == data) {
                    netException.setMessage("Data\u6570\u636e\u4e3anull!");
                    this.netCallBack.onError(netException);
                } else {
                    this.netCallBack.onSuccess(data);
                }
            } else {
                this.netCallBack.onError(netException);
            }
        } else {
            this.netCallBack.onSuccess(t);
        }
    }
}

