/*
 * Decompiled with CFR 0.152.
 */
package com.therouter.flow;

import android.text.TextUtils;
import com.therouter.TheRouterKt;
import com.therouter.flow.DigraphKt;
import com.therouter.flow.Task;
import com.therouter.flow.VirtualFlowTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\rJ\u0010\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\nJ\u0006\u0010\u0019\u001a\u00020\u0017J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u001d2\u0006\u0010\u001b\u001a\u00020\nJ\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0010J\u0006\u0010 \u001a\u00020\u0017J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u000e\u0010\"\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0010J\u0006\u0010#\u001a\u00020\u0017R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/therouter/flow/Digraph;", "", "()V", "<set-?>", "", "inited", "getInited", "()Z", "loopDependStack", "", "Lcom/therouter/flow/Task;", "pendingTaskRunnableList", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ljava/lang/Runnable;", "tasks", "Ljava/util/HashMap;", "", "todoList", "virtualTasks", "Lcom/therouter/flow/VirtualFlowTask;", "addPendingRunnable", "r", "addTask", "", "task", "beforeSchedule", "fillTodoList", "root", "getDepends", "", "getVirtualTask", "name", "initSchedule", "makeVirtualFlowTask", "onVirtualTaskDoneListener", "schedule", "router_release"})
public final class Digraph {
    @NotNull
    private final HashMap<String, Task> tasks = new HashMap();
    @NotNull
    private final HashMap<String, VirtualFlowTask> virtualTasks = new HashMap();
    @NotNull
    private final CopyOnWriteArrayList<Task> todoList = new CopyOnWriteArrayList();
    @NotNull
    private final CopyOnWriteArrayList<Runnable> pendingTaskRunnableList = new CopyOnWriteArrayList();
    private volatile boolean inited;
    @NotNull
    private final List<Task> loopDependStack = new ArrayList();

    public final boolean getInited() {
        return this.inited;
    }

    public final void addTask(@Nullable Task task) {
        block1: {
            Object object;
            TheRouterKt.require(task != null, "Digraph", "Task is Null");
            Task task2 = task;
            TheRouterKt.require(!TextUtils.isEmpty((CharSequence)(task2 != null ? task2.getTaskName() : null)), "Digraph", "Task name is Empty " + ((object = task) != null && (object = object.getClass()) != null ? ((Class)object).getName() : null));
            Object object2 = task;
            if (object2 == null || (object2 = ((Task)object2).getTaskName()) == null) break block1;
            Object it = object2;
            boolean bl = false;
            if (!this.tasks.containsKey(it)) {
                ((Map)this.tasks).put(it, task);
            }
        }
    }

    public final void beforeSchedule() {
        VirtualFlowTask virtualFlowTask = this.getVirtualTask("TheRouter_Before_Initialization");
        ((Map)this.virtualTasks).put("TheRouter_Before_Initialization", virtualFlowTask);
        virtualFlowTask.run$router_release();
        Collection<Task> collection = this.tasks.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"tasks.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Task it = (Task)element$iv;
            boolean bl = false;
            if (it.getAsync() || it.getDependencies().size() != 1 || !it.getDependencies().contains("TheRouter_Before_Initialization")) continue;
            it.run$router_release();
        }
    }

    public final boolean addPendingRunnable(@NotNull Runnable r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.pendingTaskRunnableList.add(r);
    }

    public final void initSchedule() {
        for (Task task : this.tasks.values()) {
            Intrinsics.checkNotNullExpressionValue((Object)task, (String)"task");
            this.fillTodoList(task);
        }
        this.inited = true;
        Iterable $this$forEach$iv = this.pendingTaskRunnableList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Runnable it = (Runnable)element$iv;
            boolean bl = false;
            it.run();
        }
    }

    private final void fillTodoList(Task root) {
        if (!root.isDone$router_release()) {
            Set<Task> dependsSet = this.getDepends(root);
            if (DigraphKt.access$isNotEmpty(dependsSet)) {
                if (this.loopDependStack.contains(root)) {
                    throw new IllegalArgumentException("TheRouter::Digraph::Cyclic dependency " + DigraphKt.access$getLog(this.loopDependStack, root));
                }
                this.loopDependStack.add(root);
                for (Task depend : dependsSet) {
                    this.fillTodoList(depend);
                }
                this.loopDependStack.remove(root);
                if (!this.todoList.contains(root)) {
                    this.todoList.add(root);
                }
            } else if (!this.todoList.contains(root)) {
                this.todoList.add(root);
            }
        }
    }

    public final void schedule() {
        for (Task task : this.todoList) {
            if (!task.isNone$router_release()) continue;
            boolean allDependenciesDone = false;
            allDependenciesDone = true;
            Iterable $this$forEach$iv = task.getDependencies();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Task dependencyTask = this.tasks.get(it);
                if (dependencyTask == null) {
                    dependencyTask = this.virtualTasks.get(it);
                }
                if (dependencyTask == null || dependencyTask.isDone$router_release()) continue;
                allDependenciesDone = false;
            }
            if (!allDependenciesDone) continue;
            TheRouterKt.debug$default("FlowTask", "do flow task:" + task.getTaskName(), null, 4, null);
            task.run$router_release();
        }
    }

    public final void onVirtualTaskDoneListener(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Collection<VirtualFlowTask> collection = this.virtualTasks.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"virtualTasks.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFlowTask it = (VirtualFlowTask)element$iv;
            boolean bl = false;
            if (!it.getDependencies().contains(name)) continue;
            it.dependTaskStatusChanged();
        }
    }

    @NotNull
    public final VirtualFlowTask getVirtualTask(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        VirtualFlowTask virtualFlowTask = this.virtualTasks.get(name);
        if (virtualFlowTask == null) {
            Digraph it = this;
            boolean bl = false;
            VirtualFlowTask vtask = this.makeVirtualFlowTask(name);
            ((Map)this.virtualTasks).put(name, vtask);
            virtualFlowTask = vtask;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFlowTask, (String)"virtualTasks[name] ?: le\u2026vtask\n        vtask\n    }");
        return virtualFlowTask;
    }

    @NotNull
    public final Set<Task> getDepends(@NotNull Task root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Set set = new HashSet();
        HashSet<String> dependencies = root.getDependencies();
        for (String key : dependencies) {
            Task task = this.tasks.get(key);
            if (task == null) {
                Map map = this.virtualTasks;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                map.put(key, this.makeVirtualFlowTask(key));
                continue;
            }
            set.add(task);
        }
        return set;
    }

    private final VirtualFlowTask makeVirtualFlowTask(String name) {
        VirtualFlowTask virtualFlowTask;
        switch (name) {
            case "TheRouter_Before_Initialization": {
                virtualFlowTask = new VirtualFlowTask(name, null, 2, null);
                break;
            }
            case "TheRouter_Initialization": {
                virtualFlowTask = new VirtualFlowTask("TheRouter_Initialization", "TheRouter_Before_Initialization");
                break;
            }
            case "TheRouter_activity_splash": {
                virtualFlowTask = new VirtualFlowTask("TheRouter_activity_splash", "TheRouter_Initialization");
                break;
            }
            default: {
                virtualFlowTask = new VirtualFlowTask(name, "TheRouter_Initialization");
            }
        }
        return virtualFlowTask;
    }
}

