/*
 * Decompiled with CFR 0.152.
 */
package com.therouter;

import android.os.Handler;
import android.os.Looper;
import android.util.SparseArray;
import com.therouter.BufferExecutor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u001b\u0010\u001e\u001a\u00020\r2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002\u00a2\u0006\u0002\u0010\"\u001a\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\r\u001a\u0017\u0010&\u001a\u0004\u0018\u00010\u00192\b\u0010'\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010(\u001aQ\u0010)\u001a\u00020\u0019\"\u0004\b\u0000\u0010**\b\u0012\u0004\u0012\u0002H*0+26\u0010,\u001a2\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b.\u0012\b\b/\u0012\u0004\b\b(0\u0012\u0013\u0012\u0011H*\u00a2\u0006\f\b.\u0012\b\b/\u0012\u0004\b\b(1\u0012\u0004\u0012\u00020\u00190-H\u0082\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\"\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"BIGGER_CORE_POOL_SIZE", "", "CHECK_REPEAT_TASK_TIME_MILLISECOND", "", "CORE_POOL_SIZE", "CPU_COUNT", "KEEP_ALIVE_MILLISECOND", "KEEP_ALIVE_SECONDS", "MAXIMUM_CORE_POOL_SIZE", "MAXIMUM_POOL_SIZE", "MAX_QUEUE_SIZE", "MAX_REPEAT_TASK_COUNT", "THREAD_NAME", "", "executor", "Ljava/util/concurrent/ExecutorService;", "getExecutor", "()Ljava/util/concurrent/ExecutorService;", "setExecutor", "(Ljava/util/concurrent/ExecutorService;)V", "main", "Landroid/os/Handler;", "threadPoolExecutor", "Ljava/util/concurrent/ThreadPoolExecutor;", "execute", "", "command", "Ljava/lang/Runnable;", "executeInMainThread", "", "getTrace", "trace", "", "Ljava/lang/StackTraceElement;", "([Ljava/lang/StackTraceElement;)Ljava/lang/String;", "newThreadFactory", "Ljava/util/concurrent/ThreadFactory;", "threadName", "setThreadPoolExecutor", "e", "(Ljava/util/concurrent/ExecutorService;)Lkotlin/Unit;", "forEach", "T", "Landroid/util/SparseArray;", "action", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "key", "value", "router_release"})
@JvmName(name="TheRouterThreadPool")
public final class TheRouterThreadPool {
    private static final int CPU_COUNT;
    private static final int CORE_POOL_SIZE;
    private static final int BIGGER_CORE_POOL_SIZE;
    private static final int MAXIMUM_CORE_POOL_SIZE;
    private static final int MAXIMUM_POOL_SIZE = Integer.MAX_VALUE;
    private static final long KEEP_ALIVE_SECONDS = 30L;
    private static final long KEEP_ALIVE_MILLISECOND = 30000L;
    private static final int MAX_QUEUE_SIZE = 10;
    private static final int MAX_REPEAT_TASK_COUNT = 5;
    private static final long CHECK_REPEAT_TASK_TIME_MILLISECOND = 5000L;
    @NotNull
    private static final String THREAD_NAME = "TheRouterLibThread";
    @NotNull
    private static ExecutorService executor;
    @NotNull
    private static final Handler main;
    @NotNull
    private static ThreadPoolExecutor threadPoolExecutor;

    @NotNull
    public static final ExecutorService getExecutor() {
        return executor;
    }

    public static final void setExecutor(@NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"<set-?>");
        executor = executorService;
    }

    @Nullable
    public static final Unit setThreadPoolExecutor(@Nullable ExecutorService e) {
        Unit unit;
        ExecutorService executorService = e;
        if (executorService != null) {
            ExecutorService it = executorService;
            boolean bl = false;
            executor = it;
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public static final void execute(@NotNull Runnable command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        try {
            executor.execute(command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final boolean executeInMainThread(@NotNull Runnable command) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (Intrinsics.areEqual((Object)Thread.currentThread(), (Object)Looper.getMainLooper().getThread())) {
            command.run();
            bl = true;
        } else {
            bl = main.post(command);
        }
        return bl;
    }

    @NotNull
    public static final ThreadFactory newThreadFactory(@NotNull String threadName) {
        Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
        return new ThreadFactory(threadName){
            @NotNull
            private final AtomicInteger mCount;
            final /* synthetic */ String $threadName;
            {
                this.$threadName = $threadName;
                this.mCount = new AtomicInteger(1);
            }

            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                return new Thread(r, this.$threadName + " #" + this.mCount.getAndIncrement());
            }
        };
    }

    private static final String getTrace(StackTraceElement[] trace) {
        StringBuilder str = new StringBuilder();
        StackTraceElement[] $this$forEach$iv = trace;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            StackTraceElement element$iv;
            StackTraceElement it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            str.append(it).append('\n');
        }
        String string = str.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"str.toString()");
        return string;
    }

    private static final <T> void forEach(SparseArray<T> $this$forEach, Function2<? super Integer, ? super T, Unit> action) {
        boolean $i$f$forEach = false;
        int n = $this$forEach.size();
        for (int index = 0; index < n; ++index) {
            action.invoke((Object)$this$forEach.keyAt(index), $this$forEach.valueAt(index));
        }
    }

    public static final /* synthetic */ String access$getTrace(StackTraceElement[] trace) {
        return TheRouterThreadPool.getTrace(trace);
    }

    public static final /* synthetic */ ThreadPoolExecutor access$getThreadPoolExecutor$p() {
        return threadPoolExecutor;
    }

    public static final /* synthetic */ int access$getMAXIMUM_CORE_POOL_SIZE$p() {
        return MAXIMUM_CORE_POOL_SIZE;
    }

    public static final /* synthetic */ int access$getBIGGER_CORE_POOL_SIZE$p() {
        return BIGGER_CORE_POOL_SIZE;
    }

    public static final /* synthetic */ int access$getCORE_POOL_SIZE$p() {
        return CORE_POOL_SIZE;
    }

    static {
        ThreadPoolExecutor threadPoolExecutor;
        CPU_COUNT = Runtime.getRuntime().availableProcessors();
        CORE_POOL_SIZE = Math.max(3, Math.min(CPU_COUNT - 1, 6));
        BIGGER_CORE_POOL_SIZE = CPU_COUNT * 4;
        MAXIMUM_CORE_POOL_SIZE = CPU_COUNT * 8;
        executor = new BufferExecutor();
        main = new Handler(Looper.getMainLooper());
        ThreadPoolExecutor $this$threadPoolExecutor_u24lambda_u2d1 = threadPoolExecutor = new ThreadPoolExecutor(CORE_POOL_SIZE, Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingDeque(10), TheRouterThreadPool.newThreadFactory(THREAD_NAME));
        boolean bl = false;
        $this$threadPoolExecutor_u24lambda_u2d1.allowCoreThreadTimeOut(true);
        TheRouterThreadPool.threadPoolExecutor = threadPoolExecutor;
    }
}

