/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.core.util;

import cn.stylefeng.roses.kernel.model.exception.AbstractBaseExceptionEnum;
import cn.stylefeng.roses.kernel.model.exception.ServiceException;
import cn.stylefeng.roses.kernel.model.exception.enums.CoreExceptionEnum;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static Logger log = LoggerFactory.getLogger(FileUtil.class);

    public static byte[] toByteArray(String filename) {
        File f = new File(filename);
        if (!f.exists()) {
            log.error("\u6587\u4ef6\u672a\u627e\u5230\uff01" + filename);
            throw new ServiceException((AbstractBaseExceptionEnum)CoreExceptionEnum.FILE_NOT_FOUND);
        }
        AbstractInterruptibleChannel channel = null;
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(f);
            channel = fs.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)((FileChannel)channel).size());
            while (((FileChannel)channel).read(byteBuffer) > 0) {
            }
            byte[] byArray = byteBuffer.array();
            return byArray;
        }
        catch (IOException e) {
            throw new ServiceException((AbstractBaseExceptionEnum)CoreExceptionEnum.FILE_READING_ERROR);
        }
        finally {
            try {
                channel.close();
            }
            catch (IOException e) {
                throw new ServiceException((AbstractBaseExceptionEnum)CoreExceptionEnum.FILE_READING_ERROR);
            }
            try {
                fs.close();
            }
            catch (IOException e) {
                throw new ServiceException((AbstractBaseExceptionEnum)CoreExceptionEnum.FILE_READING_ERROR);
            }
        }
    }
}

