/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.core.treebuild;

import cn.stylefeng.roses.core.treebuild.abst.AbstractTreeBuildFactory;
import cn.stylefeng.roses.kernel.model.tree.Tree;
import java.util.ArrayList;
import java.util.List;

public class DefaultTreeBuildFactory<T extends Tree>
extends AbstractTreeBuildFactory<T> {
    private String rootParentId = "-1";

    private void buildChildNodes(List<T> totalNodes, T node, List<T> childNodeLists) {
        if (totalNodes == null || node == null) {
            return;
        }
        List<T> nodeSubLists = this.getSubChildsLevelOne(totalNodes, node);
        if (nodeSubLists.size() != 0) {
            for (Tree nodeSubList : nodeSubLists) {
                this.buildChildNodes(totalNodes, nodeSubList, new ArrayList());
            }
        }
        childNodeLists.addAll(nodeSubLists);
        node.setChildrenNodes(childNodeLists);
    }

    private List<T> getSubChildsLevelOne(List<T> list, T node) {
        ArrayList<Tree> nodeList = new ArrayList<Tree>();
        for (Tree nodeItem : list) {
            if (!nodeItem.getNodeParentId().equals(node.getNodeId())) continue;
            nodeList.add(nodeItem);
        }
        return nodeList;
    }

    @Override
    protected List<T> beforeBuild(List<T> nodes) {
        return nodes;
    }

    @Override
    protected List<T> executeBuilding(List<T> nodes) {
        for (Tree treeNode : nodes) {
            this.buildChildNodes(nodes, treeNode, new ArrayList());
        }
        return nodes;
    }

    @Override
    protected List<T> afterBuild(List<T> nodes) {
        ArrayList<Tree> results = new ArrayList<Tree>();
        for (Tree node : nodes) {
            if (!node.getNodeParentId().equals(this.rootParentId)) continue;
            results.add(node);
        }
        return results;
    }

    public String getRootParentId() {
        return this.rootParentId;
    }

    public void setRootParentId(String rootParentId) {
        this.rootParentId = rootParentId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultTreeBuildFactory)) {
            return false;
        }
        DefaultTreeBuildFactory other = (DefaultTreeBuildFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$rootParentId = this.getRootParentId();
        String other$rootParentId = other.getRootParentId();
        return !(this$rootParentId == null ? other$rootParentId != null : !this$rootParentId.equals(other$rootParentId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultTreeBuildFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rootParentId = this.getRootParentId();
        result = result * 59 + ($rootParentId == null ? 43 : $rootParentId.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultTreeBuildFactory(rootParentId=" + this.getRootParentId() + ")";
    }
}

