/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.core.page;

import cn.stylefeng.roses.core.context.RequestDataHolder;
import cn.stylefeng.roses.core.page.PageFieldNamesContainer;
import cn.stylefeng.roses.core.request.RequestData;
import cn.stylefeng.roses.core.util.HttpContext;
import cn.stylefeng.roses.core.util.ToolUtil;
import cn.stylefeng.roses.kernel.model.page.PageQuery;
import cn.stylefeng.roses.kernel.model.util.ValidateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PageFactory {
    private static final String ASC = "asc";
    public static final String PAGE_SIZE_PARAM_NAME = "pageSize";
    public static final String PAGE_NO_PARAM_NAME = "pageNo";
    public static final String SORT_PARAM_NAME = "sort";
    public static final String ORDER_BY_PARAM_NAME = "orderBy";

    public static <T> Page<T> defaultPage() {
        String pageNoString;
        int pageSize = 20;
        int pageNo = 1;
        HttpServletRequest request = HttpContext.getRequest();
        if (request == null) {
            return new Page((long)pageNo, (long)pageSize);
        }
        String pageSizeString = PageFactory.getFieldValue(request, PAGE_SIZE_PARAM_NAME);
        if (ValidateUtil.isNotEmpty((Object)pageSizeString)) {
            pageSize = Integer.parseInt(pageSizeString);
        }
        if (ValidateUtil.isNotEmpty((Object)(pageNoString = PageFactory.getFieldValue(request, PAGE_NO_PARAM_NAME)))) {
            pageNo = Integer.parseInt(pageNoString);
        }
        String sort = PageFactory.getFieldValue(request, SORT_PARAM_NAME);
        String orderByField = PageFactory.getFieldValue(request, ORDER_BY_PARAM_NAME);
        Page page = new Page((long)pageNo, (long)pageSize);
        if (ToolUtil.isEmpty((Object)orderByField)) {
            return page;
        }
        if (ToolUtil.isEmpty((Object)sort)) {
            page.setDesc(new String[]{orderByField});
            return page;
        }
        if (ASC.equalsIgnoreCase(sort)) {
            page.setAsc(new String[]{orderByField});
        } else {
            page.setDesc(new String[]{orderByField});
        }
        return page;
    }

    public static <T> Page<T> createPage(PageQuery pageQuery) {
        int pageSize = 20;
        int pageNo = 1;
        if (pageQuery != null && ValidateUtil.isNotEmpty((Object)pageQuery.getPageSize())) {
            pageSize = pageQuery.getPageSize();
        }
        if (pageQuery != null && ValidateUtil.isNotEmpty((Object)pageQuery.getPageNo())) {
            pageNo = pageQuery.getPageNo();
        }
        if (pageQuery == null) {
            return new Page((long)pageNo, (long)pageSize);
        }
        Page page = new Page((long)pageNo, (long)pageSize);
        if (ToolUtil.isEmpty((Object)pageQuery.getSort())) {
            return page;
        }
        if (ASC.equalsIgnoreCase(pageQuery.getSort())) {
            page.setAsc(new String[]{pageQuery.getOrderByField()});
        } else {
            page.setDesc(new String[]{pageQuery.getOrderByField()});
        }
        return page;
    }

    private static String getFieldValue(HttpServletRequest request, String type) {
        String parameterValue = PageFactory.getRequestParameter(request, type);
        if (parameterValue == null) {
            return PageFactory.getRequestData(type);
        }
        return parameterValue;
    }

    private static String getRequestParameter(HttpServletRequest request, String type) {
        if (PAGE_SIZE_PARAM_NAME.equals(type)) {
            Set<String> pageSizeFieldNames = PageFieldNamesContainer.getInstance().getPageSizeFieldNames();
            for (String fieldName : pageSizeFieldNames) {
                String pageSizeValue = request.getParameter(fieldName);
                if (!ToolUtil.isNotEmpty((Object)pageSizeValue)) continue;
                return pageSizeValue;
            }
            return null;
        }
        if (PAGE_NO_PARAM_NAME.equals(type)) {
            Set<String> pageNoFieldNames = PageFieldNamesContainer.getInstance().getPageNoFieldNames();
            for (String fieldName : pageNoFieldNames) {
                String pageNoValue = request.getParameter(fieldName);
                if (!ToolUtil.isNotEmpty((Object)pageNoValue)) continue;
                return pageNoValue;
            }
            return null;
        }
        if (SORT_PARAM_NAME.equals(type)) {
            Set<String> sortFieldNames = PageFieldNamesContainer.getInstance().getSortFieldNames();
            for (String fieldName : sortFieldNames) {
                String sortValue = request.getParameter(fieldName);
                if (!ToolUtil.isNotEmpty((Object)sortValue)) continue;
                return sortValue;
            }
            return null;
        }
        if (ORDER_BY_PARAM_NAME.equals(type)) {
            Set<String> orderByFieldNames = PageFieldNamesContainer.getInstance().getOrderByFieldNames();
            for (String fieldName : orderByFieldNames) {
                String orderByValue = request.getParameter(fieldName);
                if (!ToolUtil.isNotEmpty((Object)orderByValue)) continue;
                return orderByValue;
            }
            return null;
        }
        return null;
    }

    private static String getRequestData(String type) {
        if (PAGE_SIZE_PARAM_NAME.equals(type)) {
            Set<String> pageSizeFieldNames = PageFieldNamesContainer.getInstance().getPageSizeFieldNames();
            return PageFactory.getValueFromRequestData(pageSizeFieldNames);
        }
        if (PAGE_NO_PARAM_NAME.equals(type)) {
            Set<String> pageNoFieldNames = PageFieldNamesContainer.getInstance().getPageNoFieldNames();
            return PageFactory.getValueFromRequestData(pageNoFieldNames);
        }
        if (SORT_PARAM_NAME.equals(type)) {
            Set<String> sortFieldNames = PageFieldNamesContainer.getInstance().getSortFieldNames();
            return PageFactory.getValueFromRequestData(sortFieldNames);
        }
        if (ORDER_BY_PARAM_NAME.equals(type)) {
            Set<String> orderByFieldNames = PageFieldNamesContainer.getInstance().getOrderByFieldNames();
            return PageFactory.getValueFromRequestData(orderByFieldNames);
        }
        return null;
    }

    private static String getValueFromRequestData(Set<String> fieldNames) {
        for (String fieldName : fieldNames) {
            RequestData requestData = RequestDataHolder.get();
            if (requestData == null) {
                return null;
            }
            Object fieldValue = requestData.get(fieldName);
            if (fieldValue == null) continue;
            return fieldValue.toString();
        }
        return null;
    }
}

