/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.core.datascope;

import cn.hutool.core.collection.CollectionUtil;
import cn.stylefeng.roses.core.datascope.DataScope;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DataScopeInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaStatementHandler = SystemMetaObject.forObject((Object)statementHandler);
        MappedStatement mappedStatement = (MappedStatement)metaStatementHandler.getValue("delegate.mappedStatement");
        if (!SqlCommandType.SELECT.equals((Object)mappedStatement.getSqlCommandType())) {
            return invocation.proceed();
        }
        Connection connection = (Connection)invocation.getArgs()[0];
        DbType dbType = JdbcUtils.getDbType((String)connection.getMetaData().getURL());
        BoundSql boundSql = (BoundSql)metaStatementHandler.getValue("delegate.boundSql");
        String originalSql = boundSql.getSql();
        Object parameterObject = boundSql.getParameterObject();
        DataScope dataScope = this.findDataScopeObject(parameterObject);
        if (dataScope == null) {
            return invocation.proceed();
        }
        String scopeName = dataScope.getScopeName();
        List<Long> deptIds = dataScope.getDeptIds();
        String join = CollectionUtil.join(deptIds, (CharSequence)",");
        originalSql = dbType != null && dbType.equals((Object)DbType.POSTGRE_SQL) ? "select * from (" + originalSql + ") temp_data_scope where temp_data_scope.\"" + scopeName + "\" in (" + join + ")" : "select * from (" + originalSql + ") temp_data_scope where temp_data_scope." + scopeName + " in (" + join + ")";
        metaStatementHandler.setValue("delegate.boundSql.sql", (Object)originalSql);
        return invocation.proceed();
    }

    public DataScope findDataScopeObject(Object parameterObj) {
        if (parameterObj instanceof DataScope) {
            return (DataScope)parameterObj;
        }
        if (parameterObj instanceof Map) {
            for (Object val : ((Map)parameterObj).values()) {
                if (!(val instanceof DataScope)) continue;
                return (DataScope)val;
            }
        }
        return null;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

