/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    static final Pattern REPLACE_BLANK_PATTERN = Pattern.compile("\\s*|\t|\r|\n");

    private StringUtils() {
    }

    public static String format(String target, Object ... params) {
        return String.format(target, params);
    }

    public static boolean isBlank(CharSequence cs) {
        if (cs == null) {
            return true;
        }
        int l = cs.length();
        if (l > 0) {
            for (int i = 0; i < l; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Matcher m = REPLACE_BLANK_PATTERN.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static String defaultString(String str, String defaultStr) {
        return StringUtils.isBlank(str) ? defaultStr : str;
    }
}

