/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.util;

import java.io.File;

public class FileUtils {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");

    public static String getRealFilePath(String path) {
        return path.replace("/", FILE_SEPARATOR).replace("\\", FILE_SEPARATOR);
    }

    public static String getFileName(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getFileName(file.getPath());
    }

    public static String getFileName(String filePath) {
        if (FILE_SEPARATOR.equals(filePath)) {
            return filePath;
        }
        int lastSep = filePath.lastIndexOf(File.separator);
        return lastSep == -1 ? filePath : filePath.substring(lastSep + 1);
    }

    public static File getFileByPath(String filePath) {
        return File.separator.equals(filePath) ? null : new File(filePath);
    }

    public static boolean isFileExists(String filePath) {
        return FileUtils.isFileExists(FileUtils.getFileByPath(filePath));
    }

    public static boolean isFileExists(File file) {
        return file != null && file.exists();
    }
}

