/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.query;

import cn.smallbun.screw.core.query.DatabaseQuery;
import cn.smallbun.screw.core.util.ExceptionUtils;
import cn.smallbun.screw.core.util.JdbcUtils;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DatabaseQueryFactory
implements Serializable {
    private DataSource dataSource;

    private DatabaseQueryFactory() {
    }

    public DatabaseQueryFactory(DataSource source) {
        this.dataSource = source;
    }

    public DatabaseQuery newInstance() {
        try {
            String url = this.getDataSource().getConnection().getMetaData().getURL();
            Class<? extends DatabaseQuery> query = JdbcUtils.getDbType(url).getImplClass();
            Constructor<? extends DatabaseQuery> constructor = query.getConstructor(DataSource.class);
            return constructor.newInstance(this.dataSource);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | SQLException e) {
            throw ExceptionUtils.mpe(e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

