/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.execute;

import cn.smallbun.screw.core.Configuration;
import cn.smallbun.screw.core.engine.EngineFactory;
import cn.smallbun.screw.core.engine.TemplateEngine;
import cn.smallbun.screw.core.exception.BuilderException;
import cn.smallbun.screw.core.execute.AbstractExecute;
import cn.smallbun.screw.core.metadata.model.DataModel;
import cn.smallbun.screw.core.process.DataModelProcess;
import cn.smallbun.screw.core.util.ExceptionUtils;

public class DocumentationExecute
extends AbstractExecute {
    public DocumentationExecute(Configuration config) {
        super(config);
    }

    @Override
    public void execute() throws BuilderException {
        try {
            long start = System.currentTimeMillis();
            DataModel dataModel = new DataModelProcess(this.config).process();
            TemplateEngine produce = new EngineFactory(this.config.getEngineConfig()).newInstance();
            produce.produce(dataModel, this.getDocName(dataModel.getDatabase()));
            this.logger.debug("database document generation complete time consuming:{}ms", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw ExceptionUtils.mpe(e);
        }
    }
}

