/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.engine;

import cn.smallbun.screw.core.engine.EngineConfig;
import cn.smallbun.screw.core.engine.TemplateEngine;
import cn.smallbun.screw.core.exception.ProduceException;
import cn.smallbun.screw.core.util.Assert;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class EngineFactory
implements Serializable {
    private EngineConfig engineConfig;

    public EngineFactory(EngineConfig configuration) {
        Assert.notNull(configuration, "EngineConfig can not be empty!", new Object[0]);
        this.engineConfig = configuration;
    }

    private EngineFactory() {
    }

    public TemplateEngine newInstance() {
        try {
            Class<? extends TemplateEngine> query = this.engineConfig.getProduceType().getImplClass();
            Constructor<? extends TemplateEngine> constructor = query.getConstructor(EngineConfig.class);
            return constructor.newInstance(this.engineConfig);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ProduceException(e);
        }
    }

    public EngineConfig getEngineConfig() {
        return this.engineConfig;
    }
}

