/*
 * Decompiled with CFR 0.152.
 */
package cn.simonlee.widget.swipeback;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.app.ActivityOptions;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import cn.simonlee.widget.swipeback.DecelerateAnimator;
import cn.simonlee.widget.swipeback.ShadowView;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

@RequiresApi(api=19)
public class SwipeBackHelper {
    protected final int DIRECTION_NONE = 0;
    protected final int DIRECTION_VERTICAL = 1;
    protected final int DIRECTION_HORIZONTAL = 2;
    protected final int mOrientation;
    protected final int mTouchSlop;
    protected float mStartX;
    protected float mStartY;
    private Activity mActivity;
    private int mDragDirection;
    private float mSwipeBackEnableDistance;
    private ViewGroup mDecorView;
    private ViewGroup mSwipeBackView;
    private View mShadowView;
    private VelocityTracker mVelocityTracker;
    private DecelerateAnimator mSwipeBackAnimator;
    private int mCurTouchPointerId;
    private boolean isSwipeBackEnabled;
    private Object mTranslucentConversionListener;
    private Class mTranslucentConversionListenerClass;
    private boolean isTranslucentCompleted;
    private Animator.AnimatorListener mAnimatorListener;
    private ValueAnimator.AnimatorUpdateListener mAnimatorUpdateListener;

    public SwipeBackHelper(@NonNull Activity activity) {
        this((Context)activity, activity);
    }

    protected SwipeBackHelper(@NonNull Context context, Activity activity) {
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mOrientation = context.getResources().getConfiguration().orientation;
        this.setSwipeBackEnabled(true);
        this.setSwipeBackEnableDistance(20.0f * context.getResources().getDisplayMetrics().density);
        this.mActivity = activity;
    }

    public void setSwipeBackEnableDistance(float distance) {
        this.mSwipeBackEnableDistance = distance;
    }

    public boolean isSwipeBackEnabled() {
        return this.isSwipeBackEnabled;
    }

    public void setSwipeBackEnabled(boolean enabled) {
        this.isSwipeBackEnabled = enabled;
        if (!enabled) {
            this.onSwipeBackEvent(0);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (!this.isSwipeBackEnabled() || this.getActivity().isTaskRoot()) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        int actionIndex = event.getActionIndex();
        block0 : switch (event.getActionMasked()) {
            case 0: {
                this.mDragDirection = 0;
                this.mStartX = event.getX(actionIndex);
                this.mStartY = event.getY(actionIndex);
                this.mCurTouchPointerId = event.getPointerId(actionIndex);
                if (this.mSwipeBackAnimator != null && this.mSwipeBackAnimator.isStarted()) {
                    this.mSwipeBackAnimator.cancel();
                    this.mDragDirection = 2;
                    this.mStartX -= this.getSwipeBackView().getTranslationX();
                    return true;
                }
                if (!(this.mStartX < this.mSwipeBackEnableDistance)) break;
                this.prepareSwipeViews();
                this.convertToTranslucent();
                break;
            }
            case 6: {
                if (this.mDragDirection != 2 || event.getPointerId(actionIndex) != this.mCurTouchPointerId) break;
                this.mVelocityTracker.clear();
                for (int index = 0; index < event.getPointerCount(); ++index) {
                    int touchPointerId = event.getPointerId(index);
                    if (touchPointerId == this.mCurTouchPointerId) continue;
                    this.mStartX = event.getX(index) - this.getSwipeBackView().getTranslationX();
                    this.mStartY = event.getY(index);
                    this.mCurTouchPointerId = touchPointerId;
                    break block0;
                }
                break;
            }
            case 2: {
                for (int index = 0; index < event.getPointerCount(); ++index) {
                    if (event.getPointerId(index) != this.mCurTouchPointerId) continue;
                    if (this.mDragDirection == 2) {
                        this.onSwipeBackEvent((int)(event.getX(index) - this.mStartX + 0.5f));
                        return true;
                    }
                    if (this.mDragDirection != 0 || !(this.mStartX < this.mSwipeBackEnableDistance)) break block0;
                    this.mDragDirection = this.resolveDragDirection(event.getX(index), event.getY(index));
                    if (this.mDragDirection != 2) break block0;
                    this.HideInputSoft();
                    event.setAction(3);
                    break block0;
                }
                break;
            }
            case 1: 
            case 3: {
                if (this.mDragDirection == 2) {
                    this.mVelocityTracker.computeCurrentVelocity(1000);
                    this.startSwipeBackAnimator(event.getX(actionIndex) - this.mStartX, this.mVelocityTracker.getXVelocity());
                } else {
                    this.convertFromTranslucent();
                }
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        return false;
    }

    public void onTouchEvent(MotionEvent event) {
        if (!this.isSwipeBackEnabled() || this.getActivity().isTaskRoot()) {
            return;
        }
        if (this.mDragDirection != 0 || this.mStartX < this.mSwipeBackEnableDistance) {
            return;
        }
        block0 : switch (event.getActionMasked()) {
            case 0: {
                this.prepareSwipeViews();
                this.convertToTranslucent();
                break;
            }
            case 2: {
                for (int index = 0; index < event.getPointerCount(); ++index) {
                    if (event.getPointerId(index) != this.mCurTouchPointerId) continue;
                    this.mDragDirection = this.resolveDragDirection(event.getX(index), event.getY(index));
                    if (this.mDragDirection != 2) break block0;
                    this.HideInputSoft();
                    break block0;
                }
                break;
            }
        }
    }

    private void prepareSwipeViews() {
        this.mSwipeBackView = this.getSwipeBackView();
        this.mShadowView = this.getShadowView();
    }

    protected int resolveDragDirection(float eventX, float eventY) {
        float distanceX = Math.abs(eventX - this.mStartX);
        float distanceY = Math.abs(eventY - this.mStartY);
        if (distanceX >= (float)this.mTouchSlop || distanceY >= (float)this.mTouchSlop) {
            if (distanceX > distanceY) {
                this.mStartX = eventX;
                this.mStartY = eventY;
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private void onSwipeBackEvent(int offsetX) {
        if (!this.isTranslucentCompleted()) {
            return;
        }
        offsetX = Math.max(0, Math.min(this.getDecorView().getWidth(), offsetX));
        this.getSwipeBackView().setTranslationX((float)offsetX);
        View shadowView = this.getShadowView();
        if (shadowView != null) {
            shadowView.setTranslationX((float)(offsetX - this.getSwipeBackView().getWidth()));
            if (shadowView.getBackground() != null) {
                int alpha = (int)((1.0f - 1.0f * (float)offsetX / (float)shadowView.getWidth()) * 255.0f);
                shadowView.getBackground().setAlpha(Math.max(0, Math.min(255, alpha)));
            }
            shadowView.setVisibility(offsetX == 0 ? 8 : 0);
        }
    }

    private void startSwipeBackAnimator(float offsetX, float velocityX) {
        offsetX = Math.max(0.0f, Math.min((float)this.getDecorView().getWidth(), offsetX));
        if (this.mSwipeBackAnimator == null) {
            this.mSwipeBackAnimator = new DecelerateAnimator(this.getActivity().getApplicationContext(), false);
            this.mSwipeBackAnimator.addListener(this.getAnimatorListener());
            this.mSwipeBackAnimator.addUpdateListener(this.getAnimatorUpdateListener());
        }
        this.mSwipeBackAnimator.setFlingFrictionRatio(9.0f);
        if (this.mOrientation == 2) {
            this.mSwipeBackAnimator.startAnimator(offsetX, 0.0f, this.getDecorView().getWidth(), velocityX * 8.0f);
        } else {
            this.mSwipeBackAnimator.startAnimator(offsetX, 0.0f, this.getDecorView().getWidth(), velocityX * 4.0f);
        }
    }

    protected void convertFromTranslucent() {
        Activity swipeBackActivity = this.getActivity();
        if (swipeBackActivity.isTaskRoot()) {
            return;
        }
        try {
            Method convertFromTranslucent = Activity.class.getDeclaredMethod("convertFromTranslucent", new Class[0]);
            convertFromTranslucent.setAccessible(true);
            convertFromTranslucent.invoke((Object)swipeBackActivity, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void convertToTranslucent() {
        block6: {
            Activity swipeBackActivity = this.getActivity();
            if (swipeBackActivity.isTaskRoot()) {
                return;
            }
            Class listenerClass = this.getTranslucentConversionListenerClass();
            Object listener = this.getTranslucentConversionListener(listenerClass);
            this.setTranslucentCompleted(listener == null);
            try {
                if (Build.VERSION.SDK_INT >= 21) {
                    Object options = null;
                    try {
                        Method getActivityOptions = Activity.class.getDeclaredMethod("getActivityOptions", new Class[0]);
                        getActivityOptions.setAccessible(true);
                        options = getActivityOptions.invoke((Object)swipeBackActivity, new Object[0]);
                    }
                    catch (Exception getActivityOptions) {
                        // empty catch block
                    }
                    Method convertToTranslucent = Activity.class.getDeclaredMethod("convertToTranslucent", listenerClass, ActivityOptions.class);
                    convertToTranslucent.setAccessible(true);
                    convertToTranslucent.invoke((Object)swipeBackActivity, listener, options);
                    break block6;
                }
                Method convertToTranslucent = Activity.class.getDeclaredMethod("convertToTranslucent", listenerClass);
                convertToTranslucent.setAccessible(true);
                convertToTranslucent.invoke((Object)swipeBackActivity, listener);
            }
            catch (Throwable ignored) {
                this.setTranslucentCompleted(true);
            }
        }
    }

    protected boolean isTranslucentCompleted() {
        return this.isTranslucentCompleted;
    }

    protected void setTranslucentCompleted(boolean completed) {
        this.isTranslucentCompleted = completed;
    }

    private Class getTranslucentConversionListenerClass() {
        if (this.mTranslucentConversionListenerClass == null) {
            for (Class<?> clazz : Activity.class.getDeclaredClasses()) {
                if (!clazz.getSimpleName().equals("TranslucentConversionListener")) continue;
                this.mTranslucentConversionListenerClass = clazz;
                return this.mTranslucentConversionListenerClass;
            }
        }
        return this.mTranslucentConversionListenerClass;
    }

    private Object getTranslucentConversionListener(Class translucentConversionListenerClass) {
        if (this.mTranslucentConversionListener == null && translucentConversionListenerClass != null) {
            this.mTranslucentConversionListener = Proxy.newProxyInstance(translucentConversionListenerClass.getClassLoader(), new Class[]{translucentConversionListenerClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) {
                    SwipeBackHelper.this.setTranslucentCompleted(true);
                    return null;
                }
            });
        }
        return this.mTranslucentConversionListener;
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public ViewGroup getDecorView() {
        if (this.mDecorView == null) {
            this.mDecorView = (ViewGroup)this.getActivity().getWindow().getDecorView();
        }
        return this.mDecorView;
    }

    public ViewGroup getSwipeBackView() {
        if (this.mSwipeBackView == null) {
            ViewParent view = (ViewParent)this.getDecorView().findViewById(0x1020002);
            while (view.getParent() != this.getDecorView()) {
                view = view.getParent();
            }
            this.mSwipeBackView = (ViewGroup)view;
            this.mSwipeBackView.setBackground(this.getDecorView().getBackground());
            this.getActivity().getWindow().setBackgroundDrawableResource(17170445);
        }
        return this.mSwipeBackView;
    }

    public View getShadowView() {
        if (this.mShadowView == null) {
            this.mShadowView = new ShadowView(this.getDecorView().getContext());
            this.mShadowView.setTranslationX((float)(-this.getSwipeBackView().getWidth()));
            ((ViewGroup)this.getSwipeBackView().getParent()).addView(this.mShadowView, new ViewGroup.LayoutParams(-1, -1));
        }
        return this.mShadowView;
    }

    public void HideInputSoft() {
        InputMethodManager inputMethodManager;
        View focusView = this.getDecorView().findFocus();
        if (focusView == null) {
            focusView = this.getActivity().getCurrentFocus();
        }
        if (focusView instanceof EditText) {
            focusView.clearFocus();
        }
        if ((inputMethodManager = (InputMethodManager)this.getActivity().getSystemService("input_method")) != null) {
            inputMethodManager.hideSoftInputFromWindow((focusView == null ? this.getDecorView() : focusView).getWindowToken(), 0);
        }
    }

    private ValueAnimator.AnimatorUpdateListener getAnimatorUpdateListener() {
        if (this.mAnimatorUpdateListener == null) {
            this.mAnimatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float translation = ((Float)animation.getAnimatedValue()).floatValue();
                    SwipeBackHelper.this.onSwipeBackEvent((int)(translation + 0.5f));
                }
            };
        }
        return this.mAnimatorUpdateListener;
    }

    private Animator.AnimatorListener getAnimatorListener() {
        if (this.mAnimatorListener == null) {
            this.mAnimatorListener = new AnimatorListenerAdapter(){
                private boolean isAnimationCancel;

                public void onAnimationStart(Animator animation) {
                    this.isAnimationCancel = false;
                }

                public void onAnimationCancel(Animator animation) {
                    this.isAnimationCancel = true;
                }

                public void onAnimationEnd(Animator animation) {
                    if (!this.isAnimationCancel) {
                        if (2.0f * SwipeBackHelper.this.getSwipeBackView().getTranslationX() >= (float)SwipeBackHelper.this.getDecorView().getWidth()) {
                            SwipeBackHelper.this.getShadowView().setVisibility(8);
                            SwipeBackHelper.this.getActivity().finish();
                            SwipeBackHelper.this.getActivity().overridePendingTransition(-1, -1);
                        } else {
                            SwipeBackHelper.this.onSwipeBackEvent(0);
                            SwipeBackHelper.this.convertFromTranslucent();
                        }
                    }
                }
            };
        }
        return this.mAnimatorListener;
    }
}

