/*
 * Decompiled with CFR 0.152.
 */
package cn.simonlee.widget.swipeback;

import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.view.ViewConfiguration;
import android.view.animation.LinearInterpolator;

public class DecelerateAnimator
extends ValueAnimator {
    private final float DECELERATION_RATE = 2.3582017f;
    private final float INFLEXION = 0.35f;
    private float mFlingFriction;
    private float mFlingFrictionRatio = 1.0f;
    private final float mPhysicalCoeff;
    private final float mBounceCoeff;
    private final boolean isBouncing;
    private final DecelerateEvaluator mDecelerateEvaluator;
    private float mInitialValue;
    private float mFinalValue;
    private long mDuration;
    private float mDistance;
    private long mBounceDuration;
    private float mBounceDistance;
    private long mOriginalDuration;
    private float mOriginalDistance;
    private float mFrictionCoeff;
    private boolean isOutside;

    public DecelerateAnimator(Context context) {
        this(context, 10.0f, true);
    }

    public DecelerateAnimator(Context context, float bounceCoeff) {
        this(context, bounceCoeff, true);
    }

    public DecelerateAnimator(Context context, boolean bouncing) {
        this(context, 10.0f, bouncing);
    }

    public DecelerateAnimator(Context context, float bounceCoeff, boolean bouncing) {
        this.mBounceCoeff = bounceCoeff;
        this.isBouncing = bouncing;
        this.mDecelerateEvaluator = new DecelerateEvaluator();
        this.mPhysicalCoeff = context.getResources().getDisplayMetrics().density * 9.80665f * 5291.328f;
        this.setInterpolator((TimeInterpolator)new LinearInterpolator());
    }

    public void startAnimator(float startValue, float finalValue, long maxDuration) {
        this.reset();
        this.mInitialValue = startValue;
        this.mDistance = finalValue - startValue;
        if (this.mDistance == 0.0f) {
            return;
        }
        this.mFinalValue = finalValue;
        this.mDuration = this.getDurationByDistance(this.mDistance);
        if (this.mDuration > maxDuration) {
            this.resetFlingFriction(this.mDistance, maxDuration);
            this.mDuration = maxDuration;
        }
        this.startAnimator();
    }

    public void startAnimator(float startValue, float minFinalValue, float maxFinalValue, float velocity) {
        if (minFinalValue >= maxFinalValue) {
            throw new ArithmeticException("maxFinalValue must be larger than minFinalValue!");
        }
        this.reset();
        this.mInitialValue = startValue;
        float distance = this.getDistanceByVelocity(velocity);
        float finalValue = startValue + distance;
        if (finalValue < minFinalValue || finalValue > maxFinalValue) {
            float f = this.mFinalValue = finalValue < minFinalValue ? minFinalValue : maxFinalValue;
            if (startValue < minFinalValue && finalValue < minFinalValue || startValue > maxFinalValue && finalValue > maxFinalValue) {
                this.mFrictionCoeff = this.mBounceCoeff;
                this.mDistance = this.mFinalValue - startValue;
                this.mDuration = this.getDurationByDistance(this.mDistance, this.mFrictionCoeff);
            } else if (this.isBouncing) {
                this.isOutside = true;
                this.mOriginalDistance = distance;
                this.mOriginalDuration = this.getDurationByDistance(distance);
                float bounceVelocity = this.getVelocityByDistance(finalValue - this.mFinalValue);
                this.mFrictionCoeff = this.mBounceCoeff;
                this.mBounceDuration = this.getDurationByVelocity(bounceVelocity, this.mFrictionCoeff);
                this.mBounceDistance = this.getDistanceByDuration(this.mBounceDuration / 2L, this.mFrictionCoeff) * Math.signum(bounceVelocity);
                this.mDuration = this.mOriginalDuration - this.getDurationByDistance(finalValue - this.mFinalValue) + this.mBounceDuration;
            } else {
                this.isOutside = true;
                this.mDistance = distance;
                this.mDuration = this.getDurationByDistance(distance);
            }
        } else {
            this.mFinalValue = finalValue * 2.0f < minFinalValue + maxFinalValue ? minFinalValue : maxFinalValue;
            this.mDistance = this.mFinalValue - startValue;
            this.mDuration = this.getDurationByDistance(this.mDistance);
        }
        this.startAnimator();
    }

    public void startAnimator_Velocity(float startValue, float velocity, float modulus) {
        this.startAnimator_Velocity(startValue, 0.0f, 0.0f, velocity, modulus);
    }

    public void startAnimator_Velocity(float startValue, float minValue, float maxValue, float velocity, float modulus) {
        this.reset();
        this.mInitialValue = startValue;
        float distance = this.getDistanceByVelocity(velocity);
        distance = this.reviseDistance(distance, startValue, modulus);
        float finalValue = startValue + distance;
        if (maxValue > minValue && (finalValue < minValue || finalValue > maxValue)) {
            float f = this.mFinalValue = finalValue < minValue ? minValue : maxValue;
            if (startValue < minValue && finalValue < minValue || startValue > maxValue && finalValue > maxValue) {
                this.mFrictionCoeff = this.mBounceCoeff;
                this.mDistance = this.mFinalValue - startValue;
                this.mDuration = this.getDurationByDistance(this.mDistance, this.mFrictionCoeff);
            } else if (this.isBouncing) {
                this.isOutside = true;
                this.mOriginalDistance = distance;
                this.mOriginalDuration = this.getDurationByDistance(distance);
                float bounceVelocity = this.getVelocityByDistance(finalValue - this.mFinalValue);
                this.mFrictionCoeff = this.mBounceCoeff;
                this.mBounceDuration = this.getDurationByVelocity(bounceVelocity, this.mFrictionCoeff);
                this.mBounceDistance = this.getDistanceByDuration(this.mBounceDuration / 2L, this.mFrictionCoeff) * Math.signum(bounceVelocity);
                this.mDuration = this.mOriginalDuration - this.getDurationByDistance(finalValue - this.mFinalValue) + this.mBounceDuration;
            } else {
                this.isOutside = true;
                this.mDistance = distance;
                this.mDuration = this.getDurationByDistance(distance);
            }
        } else {
            this.mFinalValue = finalValue;
            this.mDistance = distance;
            this.mDuration = this.getDurationByDistance(this.mDistance);
        }
        this.startAnimator();
    }

    public void startAnimator_Distance(float startValue, float distance, float modulus) {
        this.startAnimator_Distance(startValue, 0.0f, 0.0f, distance, modulus);
    }

    public void startAnimator_Distance(float startValue, float minValue, float maxValue, float distance, float modulus) {
        this.reset();
        this.mInitialValue = startValue;
        this.mDistance = this.reviseDistance(distance, startValue, modulus);
        if (this.mDistance == 0.0f) {
            return;
        }
        this.mFinalValue = startValue + this.mDistance;
        if (maxValue > minValue && (this.mFinalValue < minValue || this.mFinalValue > maxValue)) {
            return;
        }
        this.mDuration = this.getDurationByDistance(this.mDistance);
        this.startAnimator();
    }

    private void reset() {
        this.isOutside = false;
        this.mFrictionCoeff = 1.0f;
        this.mBounceDuration = 0L;
        this.mBounceDistance = 0.0f;
        this.mOriginalDuration = 0L;
        this.mOriginalDistance = 0.0f;
        this.mFlingFriction = ViewConfiguration.getScrollFriction() * this.mFlingFrictionRatio;
    }

    private void startAnimator() {
        this.setFloatValues(new float[]{this.mInitialValue, this.mFinalValue});
        this.setEvaluator(this.mDecelerateEvaluator);
        this.setDuration(this.mDuration);
        this.start();
    }

    public float reviseDistance(float distance, float startValue, float modulus) {
        int multiple;
        float remainder;
        if (modulus != 0.0f && (remainder = startValue + distance - (float)(multiple = (int)((startValue + distance) / modulus)) * modulus) != 0.0f) {
            if (remainder * 2.0f < -modulus) {
                return distance - remainder - modulus;
            }
            if (remainder * 2.0f < modulus) {
                return distance - remainder;
            }
            return distance - remainder + modulus;
        }
        return distance;
    }

    public float getVelocityByDistance(float distance) {
        return this.getVelocityByDistance(distance, 1.0f);
    }

    public float getVelocityByDistance(float distance, float frictionCoeff) {
        float velocity = 0.0f;
        if (distance != 0.0f) {
            double decelMinusOne = 1.3582017421722412;
            double l = Math.pow(Math.abs(distance) / (this.mFlingFriction * frictionCoeff * this.mPhysicalCoeff), 0.5759480700413456);
            velocity = (float)(l * (double)this.mFlingFriction * (double)frictionCoeff * (double)this.mPhysicalCoeff / (double)0.35f * 4.0 * (double)Math.signum(distance));
        }
        return velocity;
    }

    public float getDistanceByVelocity(float velocity) {
        return this.getDistanceByVelocity(velocity, 1.0f);
    }

    public float getDistanceByVelocity(float velocity, float frictionCoeff) {
        float distance = 0.0f;
        if (velocity != 0.0f) {
            double decelMinusOne = 1.3582017421722412;
            double l = Math.pow(0.35f * Math.abs(velocity / 4.0f) / (this.mFlingFriction * frictionCoeff * this.mPhysicalCoeff), 1.7362676463664735);
            distance = (float)(l * (double)this.mFlingFriction * (double)frictionCoeff * (double)this.mPhysicalCoeff * (double)Math.signum(velocity));
        }
        return distance;
    }

    public float getDistanceByDuration(long duration) {
        return this.getDistanceByDuration(duration, 1.0f);
    }

    public float getDistanceByDuration(long duration, float frictionCoeff) {
        float distance = 0.0f;
        if (duration > 0L) {
            double base = Math.pow((float)duration / 1000.0f, 2.358201742172241);
            distance = (float)(base * (double)this.mFlingFriction * (double)frictionCoeff * (double)this.mPhysicalCoeff);
        }
        return distance;
    }

    public long getDurationByVelocity(float velocity) {
        return this.getDurationByVelocity(velocity, 1.0f);
    }

    public long getDurationByVelocity(float velocity, float frictionCoeff) {
        long duration = 0L;
        if (velocity != 0.0f) {
            double decelMinusOne = 1.3582017421722412;
            duration = (long)(1000.0 * Math.pow(0.35f * Math.abs(velocity / 4.0f) / (this.mFlingFriction * frictionCoeff * this.mPhysicalCoeff), 0.7362676463664736));
        }
        return duration;
    }

    public long getDurationByDistance(float distance) {
        return this.getDurationByDistance(distance, 1.0f);
    }

    public long getDurationByDistance(float distance, float frictionCoeff) {
        long duration = 0L;
        if (distance != 0.0f) {
            double base = Math.abs(distance) / (this.mFlingFriction * frictionCoeff * this.mPhysicalCoeff);
            duration = (long)(1000.0 * Math.pow(base, 0.4240519404411316));
        }
        return duration;
    }

    private void resetFlingFriction(float distance, long duration) {
        double base = Math.pow((float)duration / 1000.0f, 2.358201742172241);
        this.mFlingFriction = (float)Math.abs((double)distance / (base * (double)this.mPhysicalCoeff));
    }

    public void setFlingFrictionRatio(float ratio) {
        if (ratio > 0.0f) {
            this.mFlingFrictionRatio = ratio;
        }
    }

    private class DecelerateEvaluator
    implements TypeEvaluator<Float> {
        private DecelerateEvaluator() {
        }

        public Float evaluate(float fraction, Float startValue, Float endValue) {
            if (!DecelerateAnimator.this.isBouncing) {
                float distance = this.getDistance(fraction, DecelerateAnimator.this.getDuration(), DecelerateAnimator.this.mDistance, DecelerateAnimator.this.mFrictionCoeff);
                if (DecelerateAnimator.this.isOutside && (distance - endValue.floatValue() + startValue.floatValue()) * DecelerateAnimator.this.mDistance > 0.0f) {
                    if (fraction > 0.0f && fraction < 1.0f) {
                        DecelerateAnimator.this.end();
                    }
                    return endValue;
                }
                return Float.valueOf(startValue.floatValue() + distance);
            }
            if (DecelerateAnimator.this.isOutside) {
                float bounceFraction = 1.0f * (float)DecelerateAnimator.this.mBounceDuration / (float)DecelerateAnimator.this.getDuration();
                if (fraction <= 1.0f - bounceFraction) {
                    fraction = fraction * (float)DecelerateAnimator.this.getDuration() / (float)DecelerateAnimator.this.mOriginalDuration;
                    float distance = this.getDistance(fraction, DecelerateAnimator.this.mOriginalDuration, DecelerateAnimator.this.mOriginalDistance, 1.0f);
                    return Float.valueOf(startValue.floatValue() + distance);
                }
                if (fraction <= 1.0f - bounceFraction / 2.0f) {
                    fraction = 2.0f * (fraction + bounceFraction - 1.0f) / bounceFraction;
                    float distance = this.getDistance(fraction, DecelerateAnimator.this.mBounceDuration / 2L, DecelerateAnimator.this.mBounceDistance, DecelerateAnimator.this.mFrictionCoeff);
                    return Float.valueOf(endValue.floatValue() + distance);
                }
                fraction = 2.0f * (1.0f - fraction) / bounceFraction;
                float distance = this.getDistance(fraction, DecelerateAnimator.this.mBounceDuration / 2L, DecelerateAnimator.this.mBounceDistance, DecelerateAnimator.this.mFrictionCoeff);
                return Float.valueOf(endValue.floatValue() + distance);
            }
            float distance = this.getDistance(fraction, DecelerateAnimator.this.getDuration(), DecelerateAnimator.this.mDistance, DecelerateAnimator.this.mFrictionCoeff);
            return Float.valueOf(startValue.floatValue() + distance);
        }

        private float getDistance(float fraction, long duration, float distance, float frictionCoeff) {
            long surplusDuration = (long)((1.0f - fraction) * (float)duration);
            float surplusDistance = DecelerateAnimator.this.getDistanceByDuration(surplusDuration, frictionCoeff) * Math.signum(distance);
            return distance - surplusDistance;
        }
    }
}

