/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.util;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import cn.qqtheme.framework.util.FileUtils;
import cn.qqtheme.framework.util.LogUtils;
import java.io.File;
import java.io.IOException;

public final class StorageUtils {
    public static boolean externalMounted() {
        String state = Environment.getExternalStorageState();
        if (state.equals("mounted")) {
            return true;
        }
        LogUtils.warn((String)"external storage unmounted");
        return false;
    }

    public static String getRootPath(Context context, boolean onlyExternalStorage, String subdir) {
        File file = StorageUtils.externalMounted() ? Environment.getExternalStorageDirectory() : (onlyExternalStorage ? new File("/") : context.getFilesDir());
        if (!TextUtils.isEmpty((CharSequence)subdir)) {
            file = new File(file, subdir);
            file.mkdirs();
        }
        String path = "/";
        if (file != null) {
            path = FileUtils.separator(file.getAbsolutePath());
        }
        LogUtils.debug((String)("storage root path: " + path));
        return path;
    }

    public static String getRootPath(Context context, String subdir) {
        return StorageUtils.getRootPath(context, false, subdir);
    }

    public static String getRootPath(Context context, boolean onlyExternalStorage) {
        return StorageUtils.getRootPath(context, onlyExternalStorage, null);
    }

    public static String getRootPath(Context context) {
        return StorageUtils.getRootPath(context, false);
    }

    public static String getDownloadPath(Context context) throws Exception {
        if (!StorageUtils.externalMounted()) {
            throw new Exception("\u5916\u7f6e\u5b58\u50a8\u4e0d\u53ef\u7528\uff01");
        }
        File file = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        return FileUtils.separator(file.getAbsolutePath());
    }

    public static String getPrivatePath(Context context, String type) {
        File file = null;
        if (StorageUtils.externalMounted()) {
            file = context.getExternalFilesDir(type);
        }
        if (file == null) {
            if (type == null) {
                file = context.getFilesDir();
            } else {
                file = new File(FileUtils.separator(context.getFilesDir().getAbsolutePath()) + type);
                file.mkdirs();
            }
        }
        return FileUtils.separator(file.getAbsolutePath());
    }

    public static String getInternalRootPath(Context context) {
        return FileUtils.separator(context.getFilesDir().getAbsolutePath());
    }

    public static String getPrivateRootPath(Context context) {
        return StorageUtils.getPrivatePath(context, null);
    }

    public static String getPluginPath(Context context) {
        return StorageUtils.getPrivatePath(context, "plugin");
    }

    public static String getTemporaryDirPath(Context context) {
        return StorageUtils.getPrivatePath(context, "temporary");
    }

    public static String getTemporaryFilePath(Context context) {
        try {
            return File.createTempFile("lyj_", ".tmp", context.getCacheDir()).getAbsolutePath();
        }
        catch (IOException e) {
            return StorageUtils.getTemporaryDirPath(context) + "lyj.tmp";
        }
    }

    public static String getCachePath(Context context, String type) {
        File file = StorageUtils.externalMounted() ? context.getExternalCacheDir() : context.getCacheDir();
        if (type != null) {
            file = new File(file, type);
            file.mkdirs();
        }
        return FileUtils.separator(file != null ? file.getAbsolutePath() : null);
    }

    public static String getCacheRootPath(Context context) {
        return StorageUtils.getCachePath(context, null);
    }
}

