/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.util;

import android.os.Debug;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LogUtils {
    private static final int MAX_STACK_TRACE_SIZE = 131071;
    private static boolean isDebug = true;
    private static String debugTag = "liyujiang";

    public static void debug(String message) {
        LogUtils.debug(debugTag, message);
    }

    public static void debug(Object object, String message) {
        LogUtils.debug(object.getClass().getSimpleName(), message);
    }

    public static void debug(String tag, String message) {
        if (isDebug) {
            try {
                Log.d((String)(debugTag + tag), (String)message);
            }
            catch (Exception e) {
                System.out.println(tag + ">>>" + message);
            }
        }
    }

    public static void warn(Throwable e) {
        LogUtils.warn(LogUtils.toStackTraceString(e));
    }

    public static void warn(String message) {
        LogUtils.warn(debugTag, message);
    }

    public static void warn(Object object, String message) {
        LogUtils.warn(object.getClass().getSimpleName(), message);
    }

    public static void warn(Object object, Throwable e) {
        LogUtils.warn(object.getClass().getSimpleName(), LogUtils.toStackTraceString(e));
    }

    public static void warn(String tag, String message) {
        if (isDebug) {
            try {
                Log.w((String)(debugTag + tag), (String)message);
            }
            catch (Exception e) {
                System.out.println(debugTag + ">>>" + message);
            }
        }
    }

    public static void error(Throwable e) {
        LogUtils.error(LogUtils.toStackTraceString(e));
    }

    public static void error(String message) {
        LogUtils.error(debugTag, message);
    }

    public static void error(Object object, String message) {
        LogUtils.error(object.getClass().getSimpleName(), message);
    }

    public static void error(Object object, Throwable e) {
        LogUtils.error(object.getClass().getSimpleName(), LogUtils.toStackTraceString(e));
    }

    public static void error(String tag, String message) {
        if (isDebug) {
            try {
                Log.e((String)(debugTag + tag), (String)message);
            }
            catch (Exception e) {
                System.out.println(debugTag + ">>>" + message);
            }
        }
    }

    public static void startMethodTracing() {
        if (isDebug) {
            Debug.startMethodTracing((String)(Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + debugTag + ".trace"));
        }
    }

    public static void stopMethodTracing() {
        if (isDebug) {
            Debug.stopMethodTracing();
        }
    }

    public static String toStackTraceString(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        String stackTraceString = sw.toString();
        if (stackTraceString.length() > 131071) {
            String disclaimer = " [stack trace too large]";
            stackTraceString = stackTraceString.substring(0, 131071 - disclaimer.length()) + disclaimer;
        }
        return stackTraceString;
    }
}

