/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.popup;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import cn.qqtheme.framework.popup.Popup;
import cn.qqtheme.framework.tool.ScreenHelper;
import cn.qqtheme.framework.util.LogUtils;

public abstract class BottomPopup<V extends View> {
    protected static final int MATCH_PARENT = -1;
    protected static final int WRAP_CONTENT = -2;
    protected Activity activity;
    protected ScreenHelper.Screen screen;
    private Popup popup;

    protected abstract V getView();

    public BottomPopup(Activity activity) {
        this.activity = activity;
        this.screen = ScreenHelper.getScreenPixels((Context)activity);
        LogUtils.debug("screen width=" + this.screen.widthPixels + ", screen height=" + this.screen.heightPixels);
        this.popup = new Popup((Context)activity);
        if (this.isFixedHeight()) {
            this.popup.setSize(this.screen.widthPixels, this.screen.heightPixels / 2);
        } else {
            this.popup.setSize(this.screen.widthPixels, -2);
        }
    }

    private void onShowPrepare() {
        this.setContentViewBefore();
        V view = this.getView();
        this.popup.setContentView((View)view);
        this.setContentViewAfter((View)view);
    }

    protected boolean isFixedHeight() {
        return false;
    }

    protected void setContentViewBefore() {
    }

    protected void setContentViewAfter(View contentView) {
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.popup.setOnDismissListener(onDismissListener);
        LogUtils.debug("popup setOnDismissListener");
    }

    public void setSize(int width, int height) {
        this.popup.setSize(width, height);
    }

    public boolean isShowing() {
        return this.popup.isShowing();
    }

    public void show() {
        LogUtils.debug("do something before popup show");
        this.onShowPrepare();
        this.popup.show();
        LogUtils.debug("popup show");
    }

    public void dismiss() {
        this.popup.dismiss();
        LogUtils.debug("popup dismiss");
    }
}

