/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.util;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Window;
import android.view.WindowManager;
import cn.qqtheme.framework.util.LogUtils;

public final class ScreenUtils {
    private static boolean isFullScreen = false;

    public static DisplayMetrics displayMetrics(Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(dm);
        LogUtils.debug("screen width=" + dm.widthPixels + "px, screen height=" + dm.heightPixels + "px, densityDpi=" + dm.densityDpi + ", density=" + dm.density);
        return dm;
    }

    public static int widthPixels(Context context) {
        return ScreenUtils.displayMetrics((Context)context).widthPixels;
    }

    public static int heightPixels(Context context) {
        return ScreenUtils.displayMetrics((Context)context).heightPixels;
    }

    public static float density(Context context) {
        return ScreenUtils.displayMetrics((Context)context).density;
    }

    public static int densityDpi(Context context) {
        return ScreenUtils.displayMetrics((Context)context).densityDpi;
    }

    public static boolean isFullScreen() {
        return isFullScreen;
    }

    public static void toggleFullScreen(Activity activity) {
        Window window = activity.getWindow();
        int flagFullscreen = 1024;
        if (isFullScreen) {
            window.clearFlags(flagFullscreen);
            isFullScreen = false;
        } else {
            window.setFlags(flagFullscreen, flagFullscreen);
            isFullScreen = true;
        }
    }

    public static void keepBright(Activity activity) {
        int keepScreenOn = 128;
        activity.getWindow().setFlags(keepScreenOn, keepScreenOn);
    }
}

