/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.qqtheme.framework.R;
import cn.qqtheme.framework.popup.ConfirmPopup;
import cn.qqtheme.framework.util.CompatUtils;
import cn.qqtheme.framework.util.ConvertUtils;
import cn.qqtheme.framework.widget.ColorPanelView;
import java.util.Locale;

public class ColorPicker
extends ConfirmPopup<LinearLayout>
implements TextView.OnEditorActionListener {
    private static final int MULTI_ID = 1;
    private static final int BLACK_ID = 2;
    private int initColor = -1;
    private ColorPanelView multiColorView;
    private ColorPanelView blackColorView;
    private EditText hexValView;
    private ColorStateList hexValDefaultColor;
    private OnColorPickListener onColorPickListener;

    public ColorPicker(Activity activity) {
        super(activity);
        this.setHalfScreen(true);
    }

    @Override
    @NonNull
    protected LinearLayout makeCenterView() {
        LinearLayout rootLayout = new LinearLayout((Context)this.activity);
        rootLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        rootLayout.setOrientation(1);
        this.blackColorView = new ColorPanelView((Context)this.activity);
        this.blackColorView.setId(2);
        this.blackColorView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, ConvertUtils.toPx((Context)this.activity, 30.0f)));
        this.blackColorView.setPointerDrawable(CompatUtils.getDrawable((Context)this.activity, R.drawable.color_picker_cursor_bottom));
        this.blackColorView.setLockPointerInBounds(false);
        this.blackColorView.setOnColorChangedListener(new ColorPanelView.OnColorChangedListener(){

            @Override
            public void onColorChanged(ColorPanelView view, int color) {
                ColorPicker.this.updateCurrentColor(color);
            }
        });
        rootLayout.addView((View)this.blackColorView);
        this.multiColorView = new ColorPanelView((Context)this.activity);
        this.multiColorView.setId(1);
        this.multiColorView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
        this.multiColorView.setPointerDrawable(CompatUtils.getDrawable((Context)this.activity, R.drawable.color_picker_cursor_top));
        this.multiColorView.setLockPointerInBounds(true);
        this.multiColorView.setOnColorChangedListener(new ColorPanelView.OnColorChangedListener(){

            @Override
            public void onColorChanged(ColorPanelView view, int color) {
                ColorPicker.this.updateCurrentColor(color);
            }
        });
        rootLayout.addView((View)this.multiColorView);
        LinearLayout previewLayout = new LinearLayout((Context)this.activity);
        previewLayout.setOrientation(0);
        previewLayout.setGravity(17);
        previewLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, ConvertUtils.toPx((Context)this.activity, 30.0f)));
        this.hexValView = new EditText((Context)this.activity);
        this.hexValView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.hexValView.setInputType(524288);
        this.hexValView.setImeOptions(6);
        this.hexValView.setGravity(17);
        this.hexValView.setBackgroundColor(this.initColor);
        this.hexValView.setTextColor(-16777216);
        this.hexValView.setShadowLayer(3.0f, 0.0f, 2.0f, -1);
        this.hexValView.setMinEms(6);
        this.hexValView.setMaxEms(8);
        this.hexValView.setPadding(0, 0, 0, 0);
        this.hexValView.setSingleLine(true);
        this.hexValView.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.hexValDefaultColor = this.hexValView.getTextColors();
        previewLayout.addView((View)this.hexValView);
        rootLayout.addView((View)previewLayout);
        return rootLayout;
    }

    @Override
    protected void setContentViewAfter(View contentView) {
        this.multiColorView.setColor(this.initColor);
        this.multiColorView.setBrightnessGradientView(this.blackColorView);
    }

    @Override
    protected void onSubmit() {
        if (this.onColorPickListener != null) {
            this.onColorPickListener.onColorPicked(this.getCurrentColor());
        }
    }

    @ColorInt
    public int getCurrentColor() {
        return Color.parseColor((String)("#" + this.hexValView.getText()));
    }

    private void updateCurrentColor(int color) {
        String hexColorString = ConvertUtils.toColorString(color, false).toUpperCase(Locale.getDefault());
        this.hexValView.setText((CharSequence)hexColorString);
        this.hexValView.setTextColor(this.hexValDefaultColor);
        this.hexValView.setBackgroundColor(color);
    }

    public void setInitColor(int initColor) {
        this.initColor = initColor;
    }

    public void setOnColorPickListener(OnColorPickListener onColorPickListener) {
        this.onColorPickListener = onColorPickListener;
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (actionId == 6) {
            InputMethodManager imm = (InputMethodManager)v.getContext().getSystemService("input_method");
            imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
            String hexString = this.hexValView.getText().toString();
            int length = hexString.length();
            if (length == 6 || length == 8) {
                try {
                    int color = Color.parseColor((String)("#" + hexString));
                    this.multiColorView.setColor(color);
                    this.hexValView.setTextColor(this.hexValDefaultColor);
                }
                catch (IllegalArgumentException e) {
                    this.hexValView.setTextColor(-65536);
                }
            } else {
                this.hexValView.setTextColor(-65536);
            }
            return true;
        }
        return false;
    }

    public static interface OnColorPickListener {
        public void onColorPicked(@ColorInt int var1);
    }
}

