/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import cn.qqtheme.framework.R;
import cn.qqtheme.framework.entity.FileItem;
import cn.qqtheme.framework.util.CompatUtils;
import cn.qqtheme.framework.util.ConvertUtils;
import cn.qqtheme.framework.util.FileUtils;
import cn.qqtheme.framework.util.LogUtils;
import java.io.File;
import java.util.ArrayList;

public class FileAdapter
extends BaseAdapter {
    public static final String DIR_ROOT = "..";
    public static final String DIR_PARENT = "";
    private Context context;
    private ArrayList<FileItem> data = new ArrayList();
    private String rootPath = null;
    private String currentPath = null;
    private String[] allowExtensions = null;
    private boolean onlyListDir = false;
    private boolean showHomeDir = false;
    private boolean showUpDir = true;
    private boolean showHideDir = true;
    private int homeIcon = R.drawable.file_picker_home;
    private int upIcon = R.drawable.file_picker_updir;
    private int folderIcon = R.drawable.file_picker_folder;
    private int fileIcon = R.drawable.file_picker_file;

    public FileAdapter(Context context) {
        this.context = context;
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public void setAllowExtensions(String[] allowExtensions) {
        this.allowExtensions = allowExtensions;
    }

    public void setOnlyListDir(boolean onlyListDir) {
        this.onlyListDir = onlyListDir;
    }

    public void setShowHomeDir(boolean showHomeDir) {
        this.showHomeDir = showHomeDir;
    }

    public void setShowUpDir(boolean showUpDir) {
        this.showUpDir = showUpDir;
    }

    public void setShowHideDir(boolean showHideDir) {
        this.showHideDir = showHideDir;
    }

    public void loadData(String path) {
        if (path == null) {
            LogUtils.warn("current directory is null");
            return;
        }
        ArrayList<FileItem> datas = new ArrayList<FileItem>();
        if (this.rootPath == null) {
            this.rootPath = path;
        }
        LogUtils.debug("current directory path: " + path);
        this.currentPath = path;
        if (this.showHomeDir) {
            FileItem fileRoot = new FileItem();
            fileRoot.setDirectory(true);
            fileRoot.setIcon(this.homeIcon);
            fileRoot.setName(DIR_ROOT);
            fileRoot.setSize(0L);
            fileRoot.setPath(this.rootPath);
            datas.add(fileRoot);
        }
        if (this.showUpDir && !path.equals("/")) {
            FileItem fileParent = new FileItem();
            fileParent.setDirectory(true);
            fileParent.setIcon(this.upIcon);
            fileParent.setName(DIR_PARENT);
            fileParent.setSize(0L);
            fileParent.setPath(new File(path).getParent());
            datas.add(fileParent);
        }
        File[] files = this.allowExtensions == null ? (this.onlyListDir ? FileUtils.listDirs(path) : FileUtils.listDirsAndFiles(path)) : (this.onlyListDir ? FileUtils.listDirs(path, this.allowExtensions) : FileUtils.listDirsAndFiles(path, this.allowExtensions));
        if (files != null) {
            for (File file : files) {
                if (!this.showHideDir && file.getName().startsWith(".")) continue;
                FileItem fileItem = new FileItem();
                boolean isDirectory = file.isDirectory();
                fileItem.setDirectory(isDirectory);
                if (isDirectory) {
                    fileItem.setIcon(this.folderIcon);
                    fileItem.setSize(0L);
                } else {
                    fileItem.setIcon(this.fileIcon);
                    fileItem.setSize(file.length());
                }
                fileItem.setName(file.getName());
                fileItem.setPath(file.getAbsolutePath());
                datas.add(fileItem);
            }
        }
        this.data.clear();
        this.data.addAll(datas);
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.data.size();
    }

    public FileItem getItem(int position) {
        return this.data.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.context).inflate(0x1090000, null);
            CompatUtils.setBackground(convertView, (Drawable)ConvertUtils.toStateListDrawable(-1, -3355444));
            holder = new ViewHolder();
            holder.imageView = (ImageView)convertView.findViewById(16908294);
            holder.textView = (TextView)convertView.findViewById(16908308);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        FileItem item = this.data.get(position);
        holder.imageView.setImageResource(item.getIcon());
        holder.textView.setText((CharSequence)item.getName());
        return convertView;
    }

    private class ViewHolder {
        ImageView imageView;
        TextView textView;

        private ViewHolder() {
        }
    }
}

