/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.util;

import android.webkit.MimeTypeMap;
import cn.qqtheme.framework.util.LogUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Pattern;

public class FileUtils {
    private FileUtils() {
    }

    public static String separator(String path) {
        if (!(path = path.replace('\\', '/')).endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public static File[] listDirs(String startDirPath, String[] excludeDirs, SortType sortType) {
        LogUtils.debug(String.format("list dir %s", startDirPath));
        ArrayList<File> dirList = new ArrayList<File>();
        File startDir = new File(startDirPath);
        if (!startDir.isDirectory()) {
            return new File[0];
        }
        File[] dirs = startDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                return f.isDirectory();
            }
        });
        if (dirs == null) {
            return new File[0];
        }
        if (excludeDirs == null) {
            excludeDirs = new String[]{};
        }
        for (File dir : dirs) {
            File file = dir.getAbsoluteFile();
            if (Arrays.deepToString(excludeDirs).contains(file.getName())) continue;
            dirList.add(file);
        }
        if (sortType.equals((Object)SortType.BY_NAME_ASC)) {
            Collections.sort(dirList, new SortByName());
        } else if (sortType.equals((Object)SortType.BY_NAME_DESC)) {
            Collections.sort(dirList, new SortByName());
            Collections.reverse(dirList);
        } else if (sortType.equals((Object)SortType.BY_TIME_ASC)) {
            Collections.sort(dirList, new SortByTime());
        } else if (sortType.equals((Object)SortType.BY_TIME_DESC)) {
            Collections.sort(dirList, new SortByTime());
            Collections.reverse(dirList);
        } else if (sortType.equals((Object)SortType.BY_SIZE_ASC)) {
            Collections.sort(dirList, new SortBySize());
        } else if (sortType.equals((Object)SortType.BY_SIZE_DESC)) {
            Collections.sort(dirList, new SortBySize());
            Collections.reverse(dirList);
        } else if (sortType.equals((Object)SortType.BY_EXTENSION_ASC)) {
            Collections.sort(dirList, new SortByExtension());
        } else if (sortType.equals((Object)SortType.BY_EXTENSION_DESC)) {
            Collections.sort(dirList, new SortByExtension());
            Collections.reverse(dirList);
        }
        return dirList.toArray(new File[dirList.size()]);
    }

    public static File[] listDirs(String startDirPath, String[] excludeDirs) {
        return FileUtils.listDirs(startDirPath, excludeDirs, SortType.BY_NAME_ASC);
    }

    public static File[] listDirs(String startDirPath) {
        return FileUtils.listDirs(startDirPath, null, SortType.BY_NAME_ASC);
    }

    public static File[] listDirsAndFiles(String startDirPath, String[] allowExtensions) {
        File[] dirs = FileUtils.listDirs(startDirPath);
        File[] files = allowExtensions == null ? FileUtils.listFiles(startDirPath) : FileUtils.listFiles(startDirPath, allowExtensions);
        if (dirs == null || files == null) {
            return null;
        }
        File[] dirsAndFiles = new File[dirs.length + files.length];
        System.arraycopy(dirs, 0, dirsAndFiles, 0, dirs.length);
        System.arraycopy(files, 0, dirsAndFiles, dirs.length, files.length);
        return dirsAndFiles;
    }

    public static File[] listDirsAndFiles(String startDirPath) {
        return FileUtils.listDirsAndFiles(startDirPath, null);
    }

    public static File[] listFiles(String startDirPath, final Pattern filterPattern, SortType sortType) {
        LogUtils.debug(String.format("list file %s", startDirPath));
        ArrayList<File> fileList = new ArrayList<File>();
        File f = new File(startDirPath);
        if (!f.isDirectory()) {
            return new File[0];
        }
        File[] files = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return false;
                }
                if (filterPattern == null) {
                    return true;
                }
                return filterPattern.matcher(f.getName()).find();
            }
        });
        if (files == null) {
            return new File[0];
        }
        for (File file : files) {
            fileList.add(file.getAbsoluteFile());
        }
        if (sortType.equals((Object)SortType.BY_NAME_ASC)) {
            Collections.sort(fileList, new SortByName());
        } else if (sortType.equals((Object)SortType.BY_NAME_DESC)) {
            Collections.sort(fileList, new SortByName());
            Collections.reverse(fileList);
        } else if (sortType.equals((Object)SortType.BY_TIME_ASC)) {
            Collections.sort(fileList, new SortByTime());
        } else if (sortType.equals((Object)SortType.BY_TIME_DESC)) {
            Collections.sort(fileList, new SortByTime());
            Collections.reverse(fileList);
        } else if (sortType.equals((Object)SortType.BY_SIZE_ASC)) {
            Collections.sort(fileList, new SortBySize());
        } else if (sortType.equals((Object)SortType.BY_SIZE_DESC)) {
            Collections.sort(fileList, new SortBySize());
            Collections.reverse(fileList);
        } else if (sortType.equals((Object)SortType.BY_EXTENSION_ASC)) {
            Collections.sort(fileList, new SortByExtension());
        } else if (sortType.equals((Object)SortType.BY_EXTENSION_DESC)) {
            Collections.sort(fileList, new SortByExtension());
            Collections.reverse(fileList);
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    public static File[] listFiles(String startDirPath, Pattern filterPattern) {
        return FileUtils.listFiles(startDirPath, filterPattern, SortType.BY_NAME_ASC);
    }

    public static File[] listFiles(String startDirPath) {
        return FileUtils.listFiles(startDirPath, null, SortType.BY_NAME_ASC);
    }

    public static File[] listFiles(String startDirPath, final String[] allowExtensions) {
        LogUtils.debug(String.format("list file %s", startDirPath));
        File file = new File(startDirPath);
        return file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String extension = FileUtils.getExtension(name);
                return Arrays.deepToString(allowExtensions).contains(extension);
            }
        });
    }

    public static File[] listFiles(String startDirPath, String allowExtension) {
        return FileUtils.listFiles(startDirPath, new String[]{allowExtension});
    }

    public static boolean exist(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static boolean delete(File file, boolean deleteRootDir) {
        LogUtils.debug(String.format("delete file %s", file.getAbsolutePath()));
        boolean result = false;
        if (file.isFile()) {
            result = FileUtils.deleteResolveEBUSY(file);
        } else {
            File[] files = file.listFiles();
            if (files == null) {
                return false;
            }
            if (files.length == 0) {
                result = deleteRootDir && FileUtils.deleteResolveEBUSY(file);
            } else {
                for (File f : files) {
                    FileUtils.delete(f, deleteRootDir);
                    result = FileUtils.deleteResolveEBUSY(f);
                }
            }
            if (deleteRootDir) {
                result = FileUtils.deleteResolveEBUSY(file);
            }
        }
        return result;
    }

    private static boolean deleteResolveEBUSY(File file) {
        File to = new File(file.getAbsolutePath() + System.currentTimeMillis());
        file.renameTo(to);
        return to.delete();
    }

    public static boolean delete(String path, boolean deleteRootDir) {
        File file = new File(path);
        if (file.exists()) {
            return FileUtils.delete(file, deleteRootDir);
        }
        return false;
    }

    public static boolean delete(String path) {
        return FileUtils.delete(path, false);
    }

    public static boolean delete(File file) {
        return FileUtils.delete(file, false);
    }

    public static boolean copy(String src, String tar) {
        File srcFile = new File(src);
        if (!srcFile.exists()) {
            return false;
        }
        return FileUtils.copy(srcFile, new File(tar));
    }

    public static boolean copy(File src, File tar) {
        try {
            LogUtils.debug(String.format("copy %s to %s", src.getAbsolutePath(), tar.getAbsolutePath()));
            if (src.isFile()) {
                FileInputStream is = new FileInputStream(src);
                FileOutputStream op = new FileOutputStream(tar);
                BufferedInputStream bis = new BufferedInputStream(is);
                BufferedOutputStream bos = new BufferedOutputStream(op);
                byte[] bt = new byte[8192];
                int len = bis.read(bt);
                while (len != -1) {
                    bos.write(bt, 0, len);
                    len = bis.read(bt);
                }
                bis.close();
                bos.close();
            } else if (src.isDirectory()) {
                File[] files = src.listFiles();
                tar.mkdirs();
                for (File file : files) {
                    FileUtils.copy(file.getAbsoluteFile(), new File(tar.getAbsoluteFile() + File.separator + file.getName()));
                }
            }
            return true;
        }
        catch (Exception e) {
            LogUtils.error(e);
            return false;
        }
    }

    public static boolean move(String src, String tar) {
        return FileUtils.move(new File(src), new File(tar));
    }

    public static boolean move(File src, File tar) {
        return FileUtils.rename(src, tar);
    }

    public static boolean rename(String oldPath, String newPath) {
        return FileUtils.rename(new File(oldPath), new File(newPath));
    }

    public static boolean rename(File src, File tar) {
        try {
            LogUtils.debug(String.format("rename %s to %s", src.getAbsolutePath(), tar.getAbsolutePath()));
            return src.renameTo(tar);
        }
        catch (Exception e) {
            LogUtils.warn(e);
            return false;
        }
    }

    public static String readText(String filepath, String charset) {
        LogUtils.debug(String.format("read %s use %s", filepath, charset));
        try {
            StringBuilder sb = new StringBuilder();
            FileInputStream fis = new FileInputStream(filepath);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, charset));
            while (br.ready()) {
                String line = br.readLine();
                if (line == null) continue;
                sb.append(line).append("\n");
            }
            br.close();
            fis.close();
            return sb.toString();
        }
        catch (Exception e) {
            LogUtils.error(e);
            return "";
        }
    }

    public static String readText(String filepath) {
        return FileUtils.readText(filepath, "utf-8");
    }

    public static byte[] readByte(String filepath) {
        LogUtils.debug(String.format("read %s", filepath));
        try {
            int len;
            FileInputStream fis = new FileInputStream(filepath);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = fis.read(buffer, 0, buffer.length)) != -1) {
                baos.write(buffer, 0, len);
            }
            byte[] data = baos.toByteArray();
            baos.close();
            fis.close();
            return data;
        }
        catch (Exception e) {
            LogUtils.error(e);
            return null;
        }
    }

    public static boolean writeText(String filepath, String content, String charset) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filepath), charset));
            writer.write(content);
            writer.close();
            return true;
        }
        catch (Exception e) {
            LogUtils.error(e);
            return false;
        }
    }

    public static boolean writeText(String filepath, String content) {
        return FileUtils.writeText(filepath, content, "utf-8");
    }

    public static boolean writeByte(String filepath, byte[] data) {
        LogUtils.debug(String.format("write %s", filepath));
        File file = new File(filepath);
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(filepath);
            fos.write(data);
            fos.close();
            return true;
        }
        catch (Exception e) {
            LogUtils.error(e);
            return false;
        }
    }

    public static boolean appendText(String path, String content) {
        LogUtils.debug(String.format("append %s", path));
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter writer = new FileWriter(file, true);
            writer.write(content);
            writer.close();
            return true;
        }
        catch (IOException e) {
            LogUtils.error(e);
            return false;
        }
    }

    public static long getLength(String path) {
        File file = new File(path);
        if (!file.isFile() || !file.exists()) {
            return 0L;
        }
        return file.length();
    }

    public static String getName(String pathOrUrl) {
        return FileUtils.getName(pathOrUrl, false);
    }

    public static String getName(String pathOrUrl, boolean useHash) {
        if (useHash) {
            return pathOrUrl.replace("/", "_") + "." + FileUtils.getExtension(pathOrUrl);
        }
        int pos = pathOrUrl.lastIndexOf(47);
        if (0 <= pos) {
            return pathOrUrl.substring(pos + 1);
        }
        return String.valueOf(System.currentTimeMillis()) + "." + FileUtils.getExtension(pathOrUrl);
    }

    public static String getNameExcludeExtension(String pathOrUrl) {
        try {
            String name = FileUtils.getName(pathOrUrl);
            return name.substring(0, name.lastIndexOf(46));
        }
        catch (Exception e) {
            LogUtils.warn(e.toString());
            return "";
        }
    }

    public static String getExtension(String pathOrUrl) {
        int dotPos = pathOrUrl.lastIndexOf(46);
        if (0 <= dotPos) {
            return pathOrUrl.substring(dotPos + 1);
        }
        return "ext";
    }

    public static String getMimeType(String pathOrUrl) {
        String ext = FileUtils.getExtension(pathOrUrl);
        MimeTypeMap map = MimeTypeMap.getSingleton();
        String mimeType = map.hasExtension(ext) ? map.getMimeTypeFromExtension(ext) : "*/*";
        LogUtils.debug(pathOrUrl + ": " + mimeType);
        return mimeType;
    }

    public static String getDateTime(String path) {
        return FileUtils.getDateTime(path, "yyyy\u5e74MM\u6708dd\u65e5HH:mm");
    }

    public static String getDateTime(String path, String format) {
        File file = new File(path);
        return FileUtils.getDateTime(file, format);
    }

    public static String getDateTime(File file, String format) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(file.lastModified());
        SimpleDateFormat chineseDateFormat = new SimpleDateFormat(format, Locale.CHINA);
        return chineseDateFormat.format(cal.getTime());
    }

    public static int compareLastModified(String path1, String path2) {
        long stamp2;
        long stamp1 = new File(path1).lastModified();
        if (stamp1 > (stamp2 = new File(path2).lastModified())) {
            return 1;
        }
        if (stamp1 < stamp2) {
            return -1;
        }
        return 0;
    }

    public static boolean makeDirs(String path) {
        return new File(path).mkdirs();
    }

    public static class SortByTime
    implements Comparator<File> {
        @Override
        public int compare(File f1, File f2) {
            if (f1 == null || f2 == null) {
                if (f1 == null) {
                    return -1;
                }
                return 1;
            }
            if (f1.isDirectory() && f2.isFile()) {
                return -1;
            }
            if (f1.isFile() && f2.isDirectory()) {
                return 1;
            }
            if (f1.lastModified() > f2.lastModified()) {
                return -1;
            }
            return 1;
        }
    }

    public static class SortBySize
    implements Comparator<File> {
        @Override
        public int compare(File f1, File f2) {
            if (f1 == null || f2 == null) {
                if (f1 == null) {
                    return -1;
                }
                return 1;
            }
            if (f1.isDirectory() && f2.isFile()) {
                return -1;
            }
            if (f1.isFile() && f2.isDirectory()) {
                return 1;
            }
            if (f1.length() < f2.length()) {
                return -1;
            }
            return 1;
        }
    }

    public static class SortByName
    implements Comparator<File> {
        private boolean caseSensitive;

        public SortByName(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public SortByName() {
            this.caseSensitive = false;
        }

        @Override
        public int compare(File f1, File f2) {
            if (f1 == null || f2 == null) {
                if (f1 == null) {
                    return -1;
                }
                return 1;
            }
            if (f1.isDirectory() && f2.isFile()) {
                return -1;
            }
            if (f1.isFile() && f2.isDirectory()) {
                return 1;
            }
            String s1 = f1.getName();
            String s2 = f2.getName();
            if (this.caseSensitive) {
                return s1.compareTo(s2);
            }
            return s1.compareToIgnoreCase(s2);
        }
    }

    public static class SortByExtension
    implements Comparator<File> {
        @Override
        public int compare(File f1, File f2) {
            if (f1 == null || f2 == null) {
                if (f1 == null) {
                    return -1;
                }
                return 1;
            }
            if (f1.isDirectory() && f2.isFile()) {
                return -1;
            }
            if (f1.isFile() && f2.isDirectory()) {
                return 1;
            }
            return f1.getName().compareToIgnoreCase(f2.getName());
        }
    }

    public static enum SortType {
        BY_NAME_ASC,
        BY_NAME_DESC,
        BY_TIME_ASC,
        BY_TIME_DESC,
        BY_SIZE_ASC,
        BY_SIZE_DESC,
        BY_EXTENSION_ASC,
        BY_EXTENSION_DESC;

    }
}

