/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import cn.qqtheme.framework.adapter.FileAdapter;
import cn.qqtheme.framework.bean.FileItem;
import cn.qqtheme.framework.popup.ConfirmPopup;
import cn.qqtheme.framework.util.ConvertUtils;
import cn.qqtheme.framework.util.LogUtils;
import cn.qqtheme.framework.util.StorageUtils;
import cn.qqtheme.framework.widget.MarqueeTextView;

public class FilePicker
extends ConfirmPopup<LinearLayout>
implements AdapterView.OnItemClickListener {
    private Mode mode;
    private String initPath;
    private FileAdapter adapter;
    private MarqueeTextView textView;
    private OnFilePickListener onFilePickListener;

    public FilePicker(Activity activity) {
        super(activity);
        this.initPath = StorageUtils.getRootPath((Context)activity);
        this.adapter = new FileAdapter((Context)activity);
    }

    @Override
    protected LinearLayout initContentView() {
        LinearLayout rootLayout = new LinearLayout((Context)this.activity);
        rootLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        rootLayout.setBackgroundColor(-1);
        rootLayout.setOrientation(1);
        this.textView = new MarqueeTextView((Context)this.activity);
        this.textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.textView.setTextColor(-16777216);
        this.textView.setGravity(16);
        int padding = ConvertUtils.toDp((Context)this.activity, 10.0f);
        this.textView.setPadding(padding, padding, padding, padding);
        rootLayout.addView((View)this.textView);
        View lineView = new View((Context)this.activity);
        lineView.setLayoutParams(new ViewGroup.LayoutParams(-1, 1));
        lineView.setBackgroundColor(-2236963);
        rootLayout.addView(lineView);
        ListView listView = new ListView((Context)this.activity);
        listView.setBackgroundColor(-1);
        listView.setDivider((Drawable)new ColorDrawable(-2236963));
        listView.setDividerHeight(1);
        listView.setCacheColorHint(0);
        listView.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        listView.setAdapter((ListAdapter)this.adapter);
        listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        rootLayout.addView((View)listView);
        return rootLayout;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        if (mode.equals((Object)Mode.Directory)) {
            this.adapter.setOnlyListDir(true);
        }
    }

    public void setRootPath(String initPath) {
        this.initPath = initPath;
    }

    public void setAllowExtensions(String[] allowExtensions) {
        this.adapter.setAllowExtensions(allowExtensions);
    }

    public void setShowUpDir(boolean showUpDir) {
        this.adapter.setShowUpDir(showUpDir);
    }

    public void setShowHomeDir(boolean showHomeDir) {
        this.adapter.setShowHomeDir(showHomeDir);
    }

    public void setShowHideDir(boolean showHideDir) {
        this.adapter.setShowHideDir(showHideDir);
    }

    @Override
    protected boolean isFixedHeight() {
        return true;
    }

    @Override
    protected void setContentViewBefore() {
        final boolean isPickFile = this.mode.equals((Object)Mode.File);
        this.setCancelVisible(!isPickFile);
        this.setSubmitText(isPickFile ? "\u53d6\u6d88" : "\u786e\u5b9a");
        super.setOnConfirmListener(new ConfirmPopup.OnConfirmListener(){

            @Override
            public void onConfirm() {
                if (isPickFile) {
                    LogUtils.debug("\u5df2\u653e\u5f03\u9009\u62e9\uff01");
                } else {
                    String currentPath = FilePicker.this.adapter.getCurrentPath();
                    LogUtils.debug("\u5df2\u9009\u62e9\u76ee\u5f55\uff1a" + currentPath);
                    if (FilePicker.this.onFilePickListener != null) {
                        FilePicker.this.onFilePickListener.onFilePicked(currentPath);
                    }
                }
            }
        });
    }

    @Override
    protected void setContentViewAfter(View contentView) {
        this.refreshCurrentDirPath(this.initPath);
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
        FileItem fileItem = (FileItem)this.adapter.getItem(position);
        if (fileItem.isDirectory()) {
            this.refreshCurrentDirPath(fileItem.getPath());
        } else {
            String clickPath = fileItem.getPath();
            if (this.mode.equals((Object)Mode.Directory)) {
                LogUtils.debug("\u9009\u62e9\u7684\u4e0d\u662f\u6709\u6548\u7684\u76ee\u5f55: " + clickPath);
            } else {
                this.dismiss();
                LogUtils.debug("\u5df2\u9009\u62e9\u6587\u4ef6\uff1a" + clickPath);
                if (this.onFilePickListener != null) {
                    this.onFilePickListener.onFilePicked(clickPath);
                }
            }
        }
    }

    private void refreshCurrentDirPath(String currentPath) {
        if (currentPath.equals("/")) {
            this.textView.setText("\u6839\u76ee\u5f55");
        } else {
            this.textView.setText(currentPath);
        }
        this.adapter.loadData(currentPath, true);
    }

    public void setOnFilePickListener(OnFilePickListener listener) {
        this.onFilePickListener = listener;
    }

    public static interface OnFilePickListener {
        public void onFilePicked(String var1);
    }

    public static enum Mode {
        Directory,
        File;

    }
}

