/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.adapter;

import android.content.Context;
import cn.qqtheme.framework.R;
import cn.qqtheme.framework.adapter.IconTextAdapter;
import cn.qqtheme.framework.bean.FileItem;
import cn.qqtheme.framework.util.FileUtils;
import cn.qqtheme.framework.util.LogUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileAdapter
extends IconTextAdapter<FileItem<Integer>> {
    public static final String DIR_ROOT = "..";
    public static final String DIR_PARENT = ".";
    private String rootPath = null;
    private String currentPath = null;
    private String[] allowExtensions = null;
    private boolean onlyListDir = false;
    private boolean showHomeDir = false;
    private boolean showUpDir = true;
    private boolean showHideDir = true;
    private int homeIcon = R.drawable.file_picker_home;
    private int upIcon = R.drawable.file_picker_updir;
    private int folderIcon = R.drawable.file_picker_folder;
    private int fileIcon = R.drawable.file_picker_file;

    public FileAdapter(Context context) {
        super(context);
    }

    public FileAdapter(Context context, List<FileItem<Integer>> data) {
        super(context, data);
    }

    public FileAdapter(Context context, int layoutRes) {
        super(context, layoutRes);
    }

    public FileAdapter(Context context, int layoutRes, List<FileItem<Integer>> data) {
        super(context, layoutRes, data);
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public void setAllowExtensions(String[] allowExtensions) {
        this.allowExtensions = allowExtensions;
    }

    public void setOnlyListDir(boolean onlyListDir) {
        this.onlyListDir = onlyListDir;
    }

    public void setShowHomeDir(boolean showHomeDir) {
        this.showHomeDir = showHomeDir;
    }

    public void setShowUpDir(boolean showUpDir) {
        this.showUpDir = showUpDir;
    }

    public void setShowHideDir(boolean showHideDir) {
        this.showHideDir = showHideDir;
    }

    public ArrayList<FileItem<Integer>> loadData(String path) {
        return this.loadData(path, true);
    }

    public ArrayList<FileItem<Integer>> loadData(String path, boolean notifyDataSetChanged) {
        ArrayList<FileItem<Integer>> datas = new ArrayList<FileItem<Integer>>();
        if (path == null) {
            LogUtils.warn("current directory is null");
            return datas;
        }
        if (this.rootPath == null) {
            this.rootPath = path;
        }
        LogUtils.debug("current directory path: " + path);
        this.currentPath = path;
        if (this.showHomeDir) {
            FileItem<Integer> fileRoot = new FileItem<Integer>();
            fileRoot.setDirectory(true);
            fileRoot.setIcon(this.homeIcon);
            fileRoot.setName(DIR_ROOT);
            fileRoot.setSize(0L);
            fileRoot.setPath(this.rootPath);
            datas.add(fileRoot);
        }
        if (this.showUpDir && !path.equals("/")) {
            FileItem<Integer> fileParent = new FileItem<Integer>();
            fileParent.setDirectory(true);
            fileParent.setIcon(this.upIcon);
            fileParent.setName(DIR_PARENT);
            fileParent.setSize(0L);
            fileParent.setPath(new File(path).getParent());
            datas.add(fileParent);
        }
        File[] files = this.allowExtensions == null ? (this.onlyListDir ? FileUtils.listDirs(path) : FileUtils.listDirsAndFiles(path)) : (this.onlyListDir ? FileUtils.listDirs(path, this.allowExtensions) : FileUtils.listDirsAndFiles(path, this.allowExtensions));
        if (files != null) {
            for (File file : files) {
                if (!this.showHideDir && file.getName().startsWith(DIR_PARENT)) continue;
                FileItem<Integer> fileItem = new FileItem<Integer>();
                boolean isDirectory = file.isDirectory();
                fileItem.setDirectory(isDirectory);
                if (isDirectory) {
                    fileItem.setIcon(this.folderIcon);
                    fileItem.setSize(0L);
                } else {
                    fileItem.setIcon(this.fileIcon);
                    fileItem.setSize(file.length());
                }
                fileItem.setName(file.getName());
                fileItem.setPath(file.getAbsolutePath());
                datas.add(fileItem);
            }
        }
        if (notifyDataSetChanged) {
            this.replaceAll(datas);
        }
        return datas;
    }
}

