/*
 * Decompiled with CFR 0.152.
 */
package cn.org.faster.framework.redis.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RedisHelper {
    private static RedisConnectionFactory factory;
    private static ObjectMapper objectMapper;

    public RedisHelper(RedisConnectionFactory factory, ObjectMapper objectMapper) {
        RedisHelper.factory = factory;
        RedisHelper.objectMapper = objectMapper;
    }

    public static <T> RedisTemplate<String, T> template(Class<T> clazz) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(factory);
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(clazz);
        jackson2JsonRedisSerializer.setObjectMapper(objectMapper);
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.afterPropertiesSet();
        return template;
    }

    public static <T> RedisTemplate<String, T> template() {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(factory);
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        jackson2JsonRedisSerializer.setObjectMapper(objectMapper);
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.afterPropertiesSet();
        return template;
    }

    public static <T> RedisTemplate<String, T> template(Type type) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(factory);
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(TypeFactory.defaultInstance().constructType(type));
        jackson2JsonRedisSerializer.setObjectMapper(objectMapper);
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.afterPropertiesSet();
        return template;
    }
}

