/*
 * Decompiled with CFR 0.152.
 */
package cn.org.faster.framework.redis.processor;

import cn.org.faster.framework.redis.annotation.RedisListener;
import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;

public class RedisListenerProcessor
implements BeanPostProcessor {
    private final RedisMessageListenerContainer redisMessageListenerContainer;

    public RedisListenerProcessor(RedisMessageListenerContainer redisMessageListenerContainer) {
        this.redisMessageListenerContainer = redisMessageListenerContainer;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, method -> (RedisListener)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RedisListener.class));
        annotatedMethods.forEach((method, v) -> {
            String[] channels;
            MessageListenerAdapter messageListenerAdapter = new MessageListenerAdapter(bean, method.getName());
            messageListenerAdapter.afterPropertiesSet();
            for (String channel : channels = v.value()) {
                this.redisMessageListenerContainer.addMessageListener((MessageListener)messageListenerAdapter, (Topic)(channel.contains("*") ? new PatternTopic(channel) : new ChannelTopic(channel)));
            }
        });
        return bean;
    }
}

