/*
 * Decompiled with CFR 0.152.
 */
package cn.org.faster.framework.redis.cache;

import cn.org.faster.framework.redis.cache.RedisGenericCache;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class RedisGenericCacheManager
extends RedisCacheManager {
    private CacheProperties cacheProperties;
    private ObjectMapper objectMapper;
    private Map<String, Type> genericCacheMap = new HashMap<String, Type>();
    private final RedisCacheWriter cacheWriter;
    private final RedisCacheConfiguration defaultCacheConfig;

    public RedisGenericCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration) {
        super(cacheWriter, defaultCacheConfiguration);
        this.cacheWriter = cacheWriter;
        this.defaultCacheConfig = defaultCacheConfiguration;
    }

    public RedisGenericCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, String ... initialCacheNames) {
        super(cacheWriter, defaultCacheConfiguration, initialCacheNames);
        this.cacheWriter = cacheWriter;
        this.defaultCacheConfig = defaultCacheConfiguration;
    }

    public RedisGenericCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, boolean allowInFlightCacheCreation, String ... initialCacheNames) {
        super(cacheWriter, defaultCacheConfiguration, allowInFlightCacheCreation, initialCacheNames);
        this.cacheWriter = cacheWriter;
        this.defaultCacheConfig = defaultCacheConfiguration;
    }

    public RedisGenericCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, Map<String, RedisCacheConfiguration> initialCacheConfigurations) {
        super(cacheWriter, defaultCacheConfiguration, initialCacheConfigurations);
        this.cacheWriter = cacheWriter;
        this.defaultCacheConfig = defaultCacheConfiguration;
    }

    public RedisGenericCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, Map<String, RedisCacheConfiguration> initialCacheConfigurations, boolean allowInFlightCacheCreation) {
        super(cacheWriter, defaultCacheConfiguration, initialCacheConfigurations, allowInFlightCacheCreation);
        this.cacheWriter = cacheWriter;
        this.defaultCacheConfig = defaultCacheConfiguration;
    }

    public void initGenericCacheMap(Map<String, Type> genericCacheMap) {
        this.genericCacheMap = genericCacheMap;
    }

    private String resetExpirationAndName(String cacheName) {
        if (StringUtils.isEmpty((Object)cacheName)) {
            return cacheName;
        }
        String[] values = cacheName.split("#");
        if (values.length > 1) {
            this.cacheProperties.getRedis().setTimeToLive(Duration.ofSeconds(Long.parseLong(values[1])));
        }
        return values[0];
    }

    protected RedisCache createRedisCache(String name, @Nullable RedisCacheConfiguration cacheConfig) {
        Type type = this.genericCacheMap.get(name);
        String cacheName = this.resetExpirationAndName(name);
        if (type == null) {
            return super.createRedisCache(cacheName, cacheConfig);
        }
        return new RedisGenericCache(cacheName, this.cacheWriter, this.determineConfiguration(type));
    }

    private <T> RedisCacheConfiguration determineConfiguration(Type type) {
        CacheProperties.Redis redisProperties = this.cacheProperties.getRedis();
        RedisCacheConfiguration config = RedisCacheConfiguration.defaultCacheConfig();
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(TypeFactory.defaultInstance().constructType(type));
        jackson2JsonRedisSerializer.setObjectMapper(this.objectMapper);
        config = config.serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)jackson2JsonRedisSerializer));
        if (redisProperties.getTimeToLive() != null) {
            config = config.entryTtl(redisProperties.getTimeToLive());
        }
        if (redisProperties.getKeyPrefix() != null) {
            config = config.prefixKeysWith(redisProperties.getKeyPrefix());
        }
        if (!redisProperties.isCacheNullValues()) {
            config = config.disableCachingNullValues();
        }
        if (!redisProperties.isUseKeyPrefix()) {
            config = config.disableKeyPrefix();
        }
        return config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisGenericCacheManager)) {
            return false;
        }
        RedisGenericCacheManager other = (RedisGenericCacheManager)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CacheProperties this$cacheProperties = this.getCacheProperties();
        CacheProperties other$cacheProperties = other.getCacheProperties();
        if (this$cacheProperties == null ? other$cacheProperties != null : !this$cacheProperties.equals(other$cacheProperties)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        if (this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper)) {
            return false;
        }
        Map<String, Type> this$genericCacheMap = this.getGenericCacheMap();
        Map<String, Type> other$genericCacheMap = other.getGenericCacheMap();
        if (this$genericCacheMap == null ? other$genericCacheMap != null : !((Object)this$genericCacheMap).equals(other$genericCacheMap)) {
            return false;
        }
        RedisCacheWriter this$cacheWriter = this.getCacheWriter();
        RedisCacheWriter other$cacheWriter = other.getCacheWriter();
        if (this$cacheWriter == null ? other$cacheWriter != null : !this$cacheWriter.equals(other$cacheWriter)) {
            return false;
        }
        RedisCacheConfiguration this$defaultCacheConfig = this.getDefaultCacheConfig();
        RedisCacheConfiguration other$defaultCacheConfig = other.getDefaultCacheConfig();
        return !(this$defaultCacheConfig == null ? other$defaultCacheConfig != null : !this$defaultCacheConfig.equals(other$defaultCacheConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisGenericCacheManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CacheProperties $cacheProperties = this.getCacheProperties();
        result = result * 59 + ($cacheProperties == null ? 43 : $cacheProperties.hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        Map<String, Type> $genericCacheMap = this.getGenericCacheMap();
        result = result * 59 + ($genericCacheMap == null ? 43 : ((Object)$genericCacheMap).hashCode());
        RedisCacheWriter $cacheWriter = this.getCacheWriter();
        result = result * 59 + ($cacheWriter == null ? 43 : $cacheWriter.hashCode());
        RedisCacheConfiguration $defaultCacheConfig = this.getDefaultCacheConfig();
        result = result * 59 + ($defaultCacheConfig == null ? 43 : $defaultCacheConfig.hashCode());
        return result;
    }

    public CacheProperties getCacheProperties() {
        return this.cacheProperties;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public Map<String, Type> getGenericCacheMap() {
        return this.genericCacheMap;
    }

    public RedisCacheWriter getCacheWriter() {
        return this.cacheWriter;
    }

    public RedisCacheConfiguration getDefaultCacheConfig() {
        return this.defaultCacheConfig;
    }

    public void setCacheProperties(CacheProperties cacheProperties) {
        this.cacheProperties = cacheProperties;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setGenericCacheMap(Map<String, Type> genericCacheMap) {
        this.genericCacheMap = genericCacheMap;
    }

    public String toString() {
        return "RedisGenericCacheManager(cacheProperties=" + this.getCacheProperties() + ", objectMapper=" + this.getObjectMapper() + ", genericCacheMap=" + this.getGenericCacheMap() + ", cacheWriter=" + this.getCacheWriter() + ", defaultCacheConfig=" + this.getDefaultCacheConfig() + ")";
    }
}

