/*
 * Decompiled with CFR 0.152.
 */
package cn.org.faster.framework.redis.cache;

import cn.org.faster.framework.core.cache.service.ICacheService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.CollectionUtils;

public class RedisCacheService
implements ICacheService {
    private StringRedisTemplate stringRedisTemplate;

    public void set(String key, String value, long exp) {
        if (exp > -1L) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, exp, TimeUnit.SECONDS);
        } else {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
        }
    }

    public String deleteAndGet(String key) {
        String value = this.get(key);
        if (value != null) {
            this.stringRedisTemplate.opsForValue().getOperations().delete((Object)key);
        }
        return value;
    }

    public void delete(String key) {
        this.stringRedisTemplate.opsForValue().getOperations().delete((Object)key);
    }

    public String get(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    public void clear(String cachePrefix) {
        Set keys = this.stringRedisTemplate.keys((Object)(cachePrefix + "*"));
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            this.stringRedisTemplate.delete((Collection)keys);
        }
    }

    public int size(String cachePrefix) {
        return this.keys(cachePrefix).size();
    }

    public boolean existKey(String key) {
        return this.stringRedisTemplate.opsForValue().getOperations().hasKey((Object)key);
    }

    public Set<String> keys(String cachePrefix) {
        return this.stringRedisTemplate.keys((Object)(cachePrefix + "*"));
    }

    public Collection<String> values(String cachePrefix) {
        ArrayList<String> list = new ArrayList<String>();
        Set<String> keys = this.keys(cachePrefix);
        keys.forEach(k -> {
            String value = this.get((String)k);
            if (value != null) {
                list.add(value);
            }
        });
        return list;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    public void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisCacheService)) {
            return false;
        }
        RedisCacheService other = (RedisCacheService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StringRedisTemplate this$stringRedisTemplate = this.getStringRedisTemplate();
        StringRedisTemplate other$stringRedisTemplate = other.getStringRedisTemplate();
        return !(this$stringRedisTemplate == null ? other$stringRedisTemplate != null : !this$stringRedisTemplate.equals(other$stringRedisTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisCacheService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StringRedisTemplate $stringRedisTemplate = this.getStringRedisTemplate();
        result = result * 59 + ($stringRedisTemplate == null ? 43 : $stringRedisTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "RedisCacheService(stringRedisTemplate=" + this.getStringRedisTemplate() + ")";
    }
}

