/*
 * Decompiled with CFR 0.152.
 */
package cn.org.faster.framework.redis.cache;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class RedisGenericCacheProcessor
implements BeanPostProcessor {
    private Map<String, Type> genericCacheMap = new HashMap<String, Type>();

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, method -> (Cacheable)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Cacheable.class));
        annotatedMethods.forEach((method, v) -> {
            for (String cacheName : v.cacheNames()) {
                this.genericCacheMap.put(cacheName, method.getGenericReturnType());
            }
        });
        return bean;
    }

    public Map<String, Type> getGenericCacheMap() {
        return this.genericCacheMap;
    }

    public void setGenericCacheMap(Map<String, Type> genericCacheMap) {
        this.genericCacheMap = genericCacheMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisGenericCacheProcessor)) {
            return false;
        }
        RedisGenericCacheProcessor other = (RedisGenericCacheProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Type> this$genericCacheMap = this.getGenericCacheMap();
        Map<String, Type> other$genericCacheMap = other.getGenericCacheMap();
        return !(this$genericCacheMap == null ? other$genericCacheMap != null : !((Object)this$genericCacheMap).equals(other$genericCacheMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisGenericCacheProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Type> $genericCacheMap = this.getGenericCacheMap();
        result = result * 59 + ($genericCacheMap == null ? 43 : ((Object)$genericCacheMap).hashCode());
        return result;
    }

    public String toString() {
        return "RedisGenericCacheProcessor(genericCacheMap=" + this.getGenericCacheMap() + ")";
    }
}

