/*
 * Decompiled with CFR 0.152.
 */
package cn.org.faster.framework.redis.cache;

import cn.org.faster.framework.core.cache.service.ICacheService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.CollectionUtils;

public class RedisCacheService
implements ICacheService {
    @Autowired
    private StringRedisTemplate redisTemplate;

    public void set(String key, String value, long exp) {
        if (exp > -1L) {
            this.redisTemplate.opsForValue().set((Object)key, (Object)value, exp, TimeUnit.SECONDS);
        } else {
            this.redisTemplate.opsForValue().set((Object)key, (Object)value);
        }
    }

    public String delete(String key) {
        String value = this.get(key);
        if (value != null) {
            this.redisTemplate.opsForValue().getOperations().delete((Object)key);
        }
        return value;
    }

    public String get(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)key);
    }

    public void clear(String cachePrefix) {
        Set keys = this.redisTemplate.keys((Object)(cachePrefix + "*"));
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            this.redisTemplate.delete((Collection)keys);
        }
    }

    public int size(String cachePrefix) {
        return this.keys(cachePrefix).size();
    }

    public Set<String> keys(String cachePrefix) {
        return this.redisTemplate.keys((Object)(cachePrefix + "*"));
    }

    public Collection<String> values(String cachePrefix) {
        ArrayList<String> list = new ArrayList<String>();
        Set<String> keys = this.keys(cachePrefix);
        keys.forEach(k -> {
            String value = this.get((String)k);
            if (value != null) {
                list.add(value);
            }
        });
        return list;
    }
}

