/*
 * Decompiled with CFR 0.152.
 */
package cn.org.faster.framework.redis.scan;

import java.util.Arrays;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;

public class ClasspathListenerScanner
extends ClassPathBeanDefinitionScanner {
    private BeanFactory beanFactory;

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public ClasspathListenerScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            this.logger.warn((Object)("No Redis Subscribe Listener was found in '" + Arrays.toString(basePackages) + "' package. Please check your configuration."));
            return beanDefinitions;
        }
        BeanDefinitionRegistry beanDefinitionRegistry = super.getRegistry();
        if (beanDefinitionRegistry == null) {
            return beanDefinitions;
        }
        beanDefinitions.forEach(item -> {
            beanDefinitionRegistry.registerBeanDefinition(item.getBeanName(), item.getBeanDefinition());
            Object registerBean = this.beanFactory.getBean(item.getBeanName());
        });
        return beanDefinitions;
    }
}

