/*
 * Decompiled with CFR 0.152.
 */
package cn.org.faster.framework.redis.registrar;

import cn.org.faster.framework.redis.annotation.RedisListenerScan;
import cn.org.faster.framework.redis.scan.ClasspathListenerScanner;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringUtils;

public class SubscribeListenerScannerRegistrar
implements BeanFactoryAware,
ImportBeanDefinitionRegistrar,
ResourceLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(SubscribeListenerScannerRegistrar.class);
    private BeanFactory beanFactory;
    private ResourceLoader resourceLoader;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(RedisListenerScan.class.getName()));
        if (annotationAttributes == null) {
            log.warn("RedisListenerScan was not found.Please check your configuration.");
            return;
        }
        ClasspathListenerScanner scanner = new ClasspathListenerScanner(registry);
        if (this.resourceLoader != null) {
            scanner.setResourceLoader(this.resourceLoader);
        }
        scanner.setBeanFactory(this.beanFactory);
        List basePackages = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
        for (String pkg : annotationAttributes.getStringArray("basePackages")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        Class annotationClass = annotationAttributes.getClass("annotationClass");
        if (!Annotation.class.equals((Object)annotationClass)) {
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationClass));
        }
        scanner.doScan(StringUtils.toStringArray((Collection)basePackages));
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

