/*
 * Decompiled with CFR 0.152.
 */
package cn.org.faster.framework.redis.cache;

import cn.org.faster.framework.core.cache.service.ICacheService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisCacheService<V>
implements ICacheService<V> {
    @Autowired
    private RedisTemplate<String, V> redisTemplate;

    public void set(String key, V value, long exp) {
        this.redisTemplate.opsForValue().set((Object)key, value, exp, TimeUnit.SECONDS);
    }

    public V delete(String key) {
        V value = this.get(key);
        if (value != null) {
            this.redisTemplate.opsForValue().getOperations().delete((Object)key);
        }
        return value;
    }

    public V get(String key) {
        return (V)this.redisTemplate.opsForValue().get((Object)key);
    }

    public void clear(String cachePrefix) {
        Set keys = this.redisTemplate.keys((Object)(cachePrefix + "*"));
        if (keys.size() > 0) {
            this.redisTemplate.delete((Collection)keys);
        }
    }

    public int size(String cachePrefix) {
        return this.keys(cachePrefix).size();
    }

    public Set<String> keys(String cachePrefix) {
        return this.redisTemplate.keys((Object)(cachePrefix + "*"));
    }

    public Collection<V> values(String cachePrefix) {
        ArrayList list = new ArrayList();
        Set<String> keys = this.keys(cachePrefix);
        keys.forEach(k -> {
            V value = this.get((String)k);
            if (value != null) {
                list.add(value);
            }
        });
        return list;
    }
}

