/*
 * Decompiled with CFR 0.152.
 */
package cn.onestravel.fivefiveplayer.view;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.view.View;
import cn.onestravel.fivefiveplayer.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\"\b\u0016\u0018\u00002\u00020\u0001:\u0001IB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J(\u0010)\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000bH\u0002J\u0012\u0010.\u001a\u00020$2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010/\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0014J\u0018\u00100\u001a\u00020$2\u0006\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u000bH\u0014J\u000e\u0010\u0015\u001a\u00020$2\u0006\u00103\u001a\u00020\u0016J\u000e\u00104\u001a\u00020$2\u0006\u00105\u001a\u00020\u000bJ\u000e\u00106\u001a\u00020$2\u0006\u00107\u001a\u00020\u000eJ\u000e\u00108\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u00109\u001a\u00020$2\u0006\u00105\u001a\u00020\u000bJ\u000e\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020\u000eJ\u000e\u0010<\u001a\u00020$2\u0006\u0010=\u001a\u00020\u0014J\b\u0010>\u001a\u00020$H\u0002J\u000e\u0010?\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u000eJ\u000e\u0010@\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u000eJ\u000e\u0010A\u001a\u00020$2\u0006\u00107\u001a\u00020\u000eJ\u000e\u0010B\u001a\u00020$2\u0006\u00105\u001a\u00020\u000bJ\u000e\u0010C\u001a\u00020$2\u0006\u00107\u001a\u00020\u000eJ\u000e\u0010D\u001a\u00020$2\u0006\u0010E\u001a\u00020\u000eJ\u000e\u0010F\u001a\u00020$2\u0006\u00107\u001a\u00020\u000eJ\u000e\u0010G\u001a\u00020$2\u0006\u00103\u001a\u00020\u0016J\u0006\u0010H\u001a\u00020$R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcn/onestravel/fivefiveplayer/view/CircleProgressBar;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "animate", "Landroid/animation/ObjectAnimator;", "backColor", "", "capStyle", "drawDegree", "", "duration", "", "endColor", "maxProgress", "onProgressChangeListener", "Lcn/onestravel/fivefiveplayer/view/CircleProgressBar$OnProgressChangedListener;", "openAnimation", "", "paint", "Landroid/graphics/Paint;", "progress", "progressColor", "progressDegree", "radius", "rotateDegree", "startColor", "startDegree", "strokeWidth", "sweepDegree", "useGradient", "drawBack", "", "canvas", "Landroid/graphics/Canvas;", "rect", "Landroid/graphics/RectF;", "drawProgress", "centerX", "centerY", "getMeasureSize", "measureSpec", "initData", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "flag", "setBackColor", "color", "setDrawDegree", "degree", "setDuration", "setEndColor", "setMaxProgress", "max", "setOnProgressChangeListener", "listener", "setPaint", "setProgress", "setRadius", "setRotateDegree", "setStartColor", "setStartDegree", "setStrokeWidth", "width", "setSweepDegree", "setUseGradient", "update", "OnProgressChangedListener", "fivefiveplayer_release"})
public class CircleProgressBar
extends View {
    private Paint paint;
    private float strokeWidth;
    private int capStyle;
    private float radius;
    private float startDegree;
    private float rotateDegree;
    private float sweepDegree;
    private int backColor;
    private boolean useGradient;
    private int progressColor;
    private int startColor;
    private int endColor;
    private boolean openAnimation;
    private long duration;
    private float maxProgress;
    private float progress;
    private float progressDegree;
    private float drawDegree;
    private OnProgressChangedListener onProgressChangeListener;
    private ObjectAnimator animate;
    private HashMap _$_findViewCache;

    private final void initData(AttributeSet attributeSet) {
        TypedArray attrs = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.FiveCircleProgressBar);
        this.strokeWidth = attrs.getDimension(R.styleable.FiveCircleProgressBar_strokeWidth, 0.0f);
        this.capStyle = attrs.getInt(R.styleable.FiveCircleProgressBar_capStyle, 0);
        this.radius = attrs.getDimension(R.styleable.FiveCircleProgressBar_radius, 0.0f);
        this.startDegree = attrs.getFloat(R.styleable.FiveCircleProgressBar_startDegree, 0.0f);
        this.rotateDegree = attrs.getFloat(R.styleable.FiveCircleProgressBar_rotateDegree, 0.0f);
        this.sweepDegree = attrs.getFloat(R.styleable.FiveCircleProgressBar_sweepDegree, 360.0f);
        this.backColor = attrs.getColor(R.styleable.FiveCircleProgressBar_backColor, Color.parseColor((String)"#e6eef6"));
        this.useGradient = attrs.getBoolean(R.styleable.FiveCircleProgressBar_useGradient, false);
        this.progressColor = attrs.getColor(R.styleable.FiveCircleProgressBar_progressColor, Color.parseColor((String)"#41a9f8"));
        this.startColor = attrs.getColor(R.styleable.FiveCircleProgressBar_progressColor, Color.parseColor((String)"#21ADF1"));
        this.endColor = attrs.getColor(R.styleable.FiveCircleProgressBar_progressColor, Color.parseColor((String)"#2287EE"));
        this.openAnimation = attrs.getBoolean(R.styleable.FiveCircleProgressBar_openAnimation, false);
        this.duration = attrs.getInt(R.styleable.FiveCircleProgressBar_duration, 500);
        this.maxProgress = attrs.getFloat(R.styleable.FiveCircleProgressBar_maxProgress, 1.0f);
        this.progress = attrs.getFloat(R.styleable.FiveCircleProgressBar_progress, 0.0f);
        this.setPaint();
        this.update();
    }

    private final void setPaint() {
        this.paint.setStrokeWidth(this.strokeWidth);
        switch (this.capStyle) {
            case 1: {
                this.paint.setStrokeCap(Paint.Cap.ROUND);
                break;
            }
            case 2: {
                this.paint.setStrokeCap(Paint.Cap.SQUARE);
                break;
            }
            default: {
                this.paint.setStrokeCap(Paint.Cap.BUTT);
            }
        }
        this.paint.setStyle(Paint.Style.STROKE);
    }

    public final void setOnProgressChangeListener(@NotNull OnProgressChangedListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.onProgressChangeListener = listener;
    }

    public final void setStrokeWidth(float width) {
        this.strokeWidth = width;
        this.setPaint();
    }

    public final void setRadius(float radius) {
        this.radius = radius;
    }

    public final void setStartDegree(float degree) {
        this.startDegree = degree;
    }

    public final void setRotateDegree(float degree) {
        this.rotateDegree = degree;
    }

    public final void setDuration(long duration) {
        this.duration = duration;
    }

    public final void setSweepDegree(float degree) {
        this.sweepDegree = degree;
    }

    public final void setBackColor(int color2) {
        this.backColor = color2;
    }

    public final void setUseGradient(boolean flag) {
        this.useGradient = flag;
    }

    public final void setStartColor(int color2) {
        this.startColor = color2;
    }

    public final void setEndColor(int color2) {
        this.endColor = color2;
    }

    public final void openAnimation(boolean flag) {
        this.openAnimation = flag;
    }

    public final void setMaxProgress(float max) {
        this.maxProgress = max;
    }

    public final void setProgress(float progress) {
        this.progress = progress;
        this.update();
    }

    public final void setDrawDegree(float degree) {
        this.drawDegree = degree;
        this.invalidate();
    }

    public final void update() {
        this.progress = Math.min(this.progress, this.maxProgress);
        this.progressDegree = this.progress / this.maxProgress * this.sweepDegree;
        this.drawDegree = 0.0f;
        if (this.openAnimation) {
            if (this.animate != null) {
                ObjectAnimator objectAnimator = this.animate;
                if (objectAnimator == null) {
                    Intrinsics.throwNpe();
                }
                objectAnimator.cancel();
            }
            ObjectAnimator objectAnimator = this.animate = ObjectAnimator.ofFloat((Object)((Object)this), (String)"drawDegree", (float[])new float[]{this.progressDegree});
            if (objectAnimator == null) {
                Intrinsics.throwNpe();
            }
            objectAnimator.setDuration(this.duration);
            ObjectAnimator objectAnimator2 = this.animate;
            if (objectAnimator2 == null) {
                Intrinsics.throwNpe();
            }
            objectAnimator2.start();
        }
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.getMeasureSize(widthMeasureSpec), this.getMeasureSize(heightMeasureSpec));
    }

    private final int getMeasureSize(int measureSpec) {
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        int result = 0;
        switch (specMode) {
            case 0x40000000: {
                result = specSize;
                break;
            }
            case -2147483648: {
                int temp = (int)(Math.ceil(((double)this.radius + (double)this.strokeWidth) * (double)2) + (double)this.getPaddingLeft() + (double)this.getPaddingRight());
                result = Math.min(temp, specSize);
                break;
            }
            default: {
                result = specSize;
            }
        }
        return result;
    }

    protected void onDraw(@Nullable Canvas canvas) {
        super.onDraw(canvas);
        if (canvas == null) {
            return;
        }
        int centerX = this.getWidth() / 2;
        int centerY = this.getHeight() / 2;
        float useWidth = (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) - this.strokeWidth * (float)2;
        float useHeight = (float)(this.getHeight() - this.getPaddingTop() - this.getPaddingBottom()) - this.strokeWidth * (float)2;
        double d = RangesKt.coerceAtMost((float)useWidth, (float)useHeight) / (float)2;
        boolean bl = false;
        float temp = (float)Math.floor(d);
        this.radius = RangesKt.coerceAtMost((float)temp, (float)this.radius);
        if (this.radius < 1.0f) {
            this.radius = RangesKt.coerceAtMost((float)useWidth, (float)useHeight) / (float)2;
        }
        if (this.rotateDegree != 0.0f) {
            canvas.rotate(this.rotateDegree, (float)centerX, (float)centerY);
        }
        RectF rect = new RectF((float)centerX - this.radius, (float)centerY - this.radius, (float)centerX + this.radius, (float)centerY + this.radius);
        this.drawBack(canvas, rect);
        this.drawProgress(canvas, centerX, centerY, rect);
    }

    private final void drawBack(Canvas canvas, RectF rect) {
        this.paint.setShader((Shader)null);
        this.paint.setColor(this.backColor);
        canvas.drawArc(rect, this.startDegree, this.sweepDegree, false, this.paint);
    }

    private final void drawProgress(Canvas canvas, int centerX, int centerY, RectF rect) {
        block2: {
            block1: {
                this.paint.setColor(-1);
                if (this.useGradient) {
                    this.paint.setShader((Shader)new SweepGradient((float)centerX, (float)centerY, this.startColor, this.endColor));
                }
                if (!this.openAnimation) break block1;
                canvas.drawArc(rect, this.startDegree, this.drawDegree, false, this.paint);
                OnProgressChangedListener onProgressChangedListener = this.onProgressChangeListener;
                if (onProgressChangedListener == null) break block2;
                OnProgressChangedListener onProgressChangedListener2 = onProgressChangedListener;
                boolean bl = false;
                boolean bl2 = false;
                OnProgressChangedListener it = onProgressChangedListener2;
                boolean bl3 = false;
                float temp = this.drawDegree == this.progressDegree ? this.progress : this.drawDegree * this.maxProgress / this.sweepDegree;
                it.onProgressChanged(temp);
                break block2;
            }
            canvas.drawArc(rect, this.startDegree, this.progressDegree, false, this.paint);
            OnProgressChangedListener onProgressChangedListener = this.onProgressChangeListener;
            if (onProgressChangedListener == null) break block2;
            OnProgressChangedListener onProgressChangedListener3 = onProgressChangedListener;
            boolean bl = false;
            boolean bl4 = false;
            OnProgressChangedListener it = onProgressChangedListener3;
            boolean bl5 = false;
            it.onProgressChanged(this.progress);
        }
    }

    public CircleProgressBar(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.paint = new Paint(1);
        this.sweepDegree = 360.0f;
        this.duration = 500L;
        this.maxProgress = 1.0f;
        this.initData(null);
    }

    public CircleProgressBar(@NotNull Context context, @NotNull AttributeSet attributeSet) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attributeSet, (String)"attributeSet");
        super(context, attributeSet);
        this.paint = new Paint(1);
        this.sweepDegree = 360.0f;
        this.duration = 500L;
        this.maxProgress = 1.0f;
        this.initData(attributeSet);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcn/onestravel/fivefiveplayer/view/CircleProgressBar$OnProgressChangedListener;", "", "onProgressChanged", "", "progress", "", "fivefiveplayer_release"})
    public static interface OnProgressChangedListener {
        public void onProgressChanged(float var1);
    }
}

