/*
 * Decompiled with CFR 0.152.
 */
package cn.onestravel.fivefiveplayer.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import java.util.Formatter;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u001c\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\u001d\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010\u001e\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u001f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ \u0010 \u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010!\u001a\u00020\u0012J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0016\u0010$\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010%\u001a\u00020\rJ\u0016\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\u0006J\u0016\u0010&\u001a\u00020\b2\u0006\u0010)\u001a\u00020*2\u0006\u0010(\u001a\u00020\u0006J\u0016\u0010+\u001a\u00020\b2\u0006\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\u0006J\u0016\u0010+\u001a\u00020\b2\u0006\u0010)\u001a\u00020*2\u0006\u0010(\u001a\u00020\u0006J\u0012\u0010,\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010-\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010.\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcn/onestravel/fivefiveplayer/utils/VideoUtils;", "", "()V", "mActionBarIsShown", "", "mSystemUiVisibilityPortrait", "", "clearFocusNotAle", "", "context", "Landroid/content/Context;", "dp2px", "dpVal", "", "focusNotAle", "formatTime", "", "milliseconds", "", "getAppBrightness", "getAppCompActivity", "Landroidx/appcompat/app/AppCompatActivity;", "getSavedPlayPosition", "uri", "Landroid/net/Uri;", "getScreenHeight", "getScreenWidth", "getSystemBrightness", "hideActionBar", "hideActionBarAndStatusBar", "hideBottomUIMenu", "hideBottomUIMenuAlways", "savePlayPosition", "position", "scanForActivity", "Landroid/app/Activity;", "setAppBrightness", "brightnessPercent", "setNavigationBarColor", "activity", "colorResId", "dialog", "Landroid/app/Dialog;", "setWindowStatusBarColor", "showActionBar", "showActionBarAndStatusBar", "showBottomUIMenu", "fivefiveplayer_release"})
public final class VideoUtils {
    private static int mSystemUiVisibilityPortrait;
    private static boolean mActionBarIsShown;
    public static final VideoUtils INSTANCE;

    @Nullable
    public final Activity scanForActivity(@Nullable Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return this.scanForActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    private final AppCompatActivity getAppCompActivity(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof AppCompatActivity) {
            return (AppCompatActivity)context;
        }
        if (context instanceof ContextThemeWrapper) {
            return this.getAppCompActivity(((ContextThemeWrapper)context).getBaseContext());
        }
        return null;
    }

    @SuppressLint(value={"RestrictedApi"})
    public final void showActionBarAndStatusBar(@Nullable Context context) {
        block0: {
            this.showActionBar(context);
            Activity activity = this.scanForActivity(context);
            if (activity == null) break block0;
            Activity activity2 = activity;
            boolean bl = false;
            boolean bl2 = false;
            Activity it = activity2;
            boolean bl3 = false;
            it.getWindow().clearFlags(1024);
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    public final void hideActionBarAndStatusBar(@Nullable Context context) {
        block0: {
            this.hideActionBar(context);
            Activity activity = this.scanForActivity(context);
            if (activity == null) break block0;
            Activity activity2 = activity;
            boolean bl = false;
            boolean bl2 = false;
            Activity it = activity2;
            boolean bl3 = false;
            it.getWindow().setFlags(1024, 1024);
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    public final void showActionBar(@Nullable Context context) {
        ActionBar ab;
        AppCompatActivity appCompatActivity = this.getAppCompActivity(context);
        if (appCompatActivity == null) {
            Intrinsics.throwNpe();
        }
        if ((ab = appCompatActivity.getSupportActionBar()) != null && mActionBarIsShown) {
            ab.setShowHideAnimationEnabled(false);
            ab.show();
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    public final void hideActionBar(@Nullable Context context) {
        ActionBar ab;
        AppCompatActivity appCompatActivity = this.getAppCompActivity(context);
        if (appCompatActivity == null) {
            Intrinsics.throwNpe();
        }
        if ((ab = appCompatActivity.getSupportActionBar()) != null) {
            ab.setShowHideAnimationEnabled(false);
            mActionBarIsShown = ab.isShowing();
            ab.hide();
        }
    }

    public final void showBottomUIMenu(@Nullable Context context) {
        block3: {
            block2: {
                int n = Build.VERSION.SDK_INT;
                if (12 > n || 18 < n) break block2;
                Activity activity = this.scanForActivity(context);
                if (activity == null) break block3;
                Activity activity2 = activity;
                boolean bl = false;
                boolean bl2 = false;
                Activity it = activity2;
                boolean bl3 = false;
                Window window = it.getWindow();
                Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"it.window");
                View view = window.getDecorView();
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"it.window.decorView");
                View v = view;
                v.setSystemUiVisibility(0);
                break block3;
            }
            if (Build.VERSION.SDK_INT < 19) break block3;
            Activity activity = this.scanForActivity(context);
            if (activity != null) {
                Activity activity3 = activity;
                boolean bl = false;
                boolean bl4 = false;
                Activity it = activity3;
                boolean bl5 = false;
                Window window = it.getWindow();
                Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"it.window");
                View view = window.getDecorView();
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"it.window.decorView");
                View decorView = view;
                if (mSystemUiVisibilityPortrait != -1) {
                    decorView.setSystemUiVisibility(mSystemUiVisibilityPortrait);
                }
            }
        }
    }

    public final void hideBottomUIMenu(@Nullable Context context) {
        block2: {
            block1: {
                int n = Build.VERSION.SDK_INT;
                if (12 > n || 18 < n) break block1;
                Activity activity = this.scanForActivity(context);
                if (activity == null) break block2;
                Activity activity2 = activity;
                boolean bl = false;
                boolean bl2 = false;
                Activity it = activity2;
                boolean bl3 = false;
                Window window = it.getWindow();
                Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"it.window");
                View view = window.getDecorView();
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"it.window.decorView");
                View v = view;
                v.setSystemUiVisibility(8);
                break block2;
            }
            if (Build.VERSION.SDK_INT < 19) break block2;
            Activity activity = this.scanForActivity(context);
            if (activity != null) {
                Activity activity3 = activity;
                boolean bl = false;
                boolean bl4 = false;
                Activity it = activity3;
                boolean bl5 = false;
                Window window = it.getWindow();
                Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"it.window");
                View view = window.getDecorView();
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"it.window.decorView");
                View decorView = view;
                mSystemUiVisibilityPortrait = decorView.getSystemUiVisibility();
                int uiOptions = 4102;
                decorView.setSystemUiVisibility(uiOptions);
            }
        }
    }

    public final void hideBottomUIMenuAlways(@Nullable Context context) {
        block2: {
            block1: {
                int n = Build.VERSION.SDK_INT;
                if (12 > n || 18 < n) break block1;
                Activity activity = this.scanForActivity(context);
                if (activity == null) break block2;
                Activity activity2 = activity;
                boolean bl = false;
                boolean bl2 = false;
                Activity it = activity2;
                boolean bl3 = false;
                Window window = it.getWindow();
                Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"it.window");
                View view = window.getDecorView();
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"it.window.decorView");
                View v = view;
                v.setSystemUiVisibility(8);
                break block2;
            }
            if (Build.VERSION.SDK_INT < 19) break block2;
            Activity activity = this.scanForActivity(context);
            if (activity != null) {
                Activity activity3 = activity;
                boolean bl = false;
                boolean bl4 = false;
                Activity it = activity3;
                boolean bl5 = false;
                Window window = it.getWindow();
                Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"it.window");
                Window _window = window;
                WindowManager.LayoutParams layoutParams = _window.getAttributes();
                Intrinsics.checkExpressionValueIsNotNull((Object)layoutParams, (String)"_window.attributes");
                WindowManager.LayoutParams params = layoutParams;
                params.systemUiVisibility = 2050;
                _window.setAttributes(params);
            }
        }
    }

    public final void focusNotAle(@Nullable Context context) {
        block0: {
            Activity activity = this.scanForActivity(context);
            if (activity == null) break block0;
            Activity activity2 = activity;
            boolean bl = false;
            boolean bl2 = false;
            Activity it = activity2;
            boolean bl3 = false;
            Window window = it.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"it.window");
            Window window2 = window;
            window2.setFlags(8, 8);
        }
    }

    public final void clearFocusNotAle(@Nullable Context context) {
        block0: {
            Activity activity = this.scanForActivity(context);
            if (activity == null) break block0;
            Activity activity2 = activity;
            boolean bl = false;
            boolean bl2 = false;
            Activity it = activity2;
            boolean bl3 = false;
            Window window = it.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"it.window");
            Window window2 = window;
            window2.clearFlags(8);
        }
    }

    public final void setWindowStatusBarColor(@NotNull Activity activity, int colorResId) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                Window window = activity.getWindow();
                window.addFlags(Integer.MIN_VALUE);
                Window window2 = window;
                Intrinsics.checkExpressionValueIsNotNull((Object)window2, (String)"window");
                window2.setStatusBarColor(activity.getResources().getColor(colorResId));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void setWindowStatusBarColor(@NotNull Dialog dialog, int colorResId) {
        Intrinsics.checkParameterIsNotNull((Object)dialog, (String)"dialog");
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                Window window;
                Window window2 = window = dialog.getWindow();
                if (window2 != null) {
                    Window window3 = window2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Window it = window3;
                    boolean bl3 = false;
                    it.addFlags(Integer.MIN_VALUE);
                    it.setStatusBarColor(dialog.getContext().getResources().getColor(colorResId));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void setNavigationBarColor(@NotNull Activity activity, int colorResId) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                Window window = activity.getWindow();
                window.addFlags(Integer.MIN_VALUE);
                Window window2 = window;
                Intrinsics.checkExpressionValueIsNotNull((Object)window2, (String)"window");
                window2.setNavigationBarColor(activity.getResources().getColor(colorResId));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void setNavigationBarColor(@NotNull Dialog dialog, int colorResId) {
        Intrinsics.checkParameterIsNotNull((Object)dialog, (String)"dialog");
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                Window window;
                Window window2 = window = dialog.getWindow();
                if (window2 != null) {
                    Window window3 = window2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Window it = window3;
                    boolean bl3 = false;
                    it.addFlags(Integer.MIN_VALUE);
                    Context context = dialog.getContext();
                    Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"dialog.context");
                    it.setNavigationBarColor(context.getResources().getColor(colorResId));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final int getScreenWidth(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return resources.getDisplayMetrics().widthPixels;
    }

    public final int getScreenHeight(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return resources.getDisplayMetrics().heightPixels;
    }

    public final void setAppBrightness(@NotNull Context context, float brightnessPercent) {
        block0: {
            Window window;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Activity activity = this.scanForActivity(context);
            if (activity == null) break block0;
            Activity activity2 = activity;
            boolean bl = false;
            boolean bl2 = false;
            Activity it = activity2;
            boolean bl3 = false;
            Window window2 = window = it.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window2, (String)"window");
            WindowManager.LayoutParams layoutParams = window2.getAttributes();
            layoutParams.screenBrightness = brightnessPercent;
            window.setAttributes(layoutParams);
        }
    }

    public final float getAppBrightness(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Context context2 = context;
        boolean bl = false;
        boolean bl2 = false;
        Context it = context2;
        boolean bl3 = false;
        float brightness = -1.0f;
        if (context instanceof Activity) {
            Window window;
            Window window2 = window = ((Activity)context).getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window2, (String)"window");
            WindowManager.LayoutParams layoutParams = window2.getAttributes();
            brightness = layoutParams.screenBrightness;
        }
        if (brightness == -1.0f) {
            brightness = (float)INSTANCE.getSystemBrightness(it) / 255.0f;
        }
        return brightness;
    }

    public final int getSystemBrightness(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"screen_brightness", (int)255);
    }

    public final int dp2px(@NotNull Context context, float dpVal) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return (int)TypedValue.applyDimension((int)1, (float)dpVal, (DisplayMetrics)resources.getDisplayMetrics());
    }

    @NotNull
    public final String formatTime(long milliseconds) {
        String string2;
        if (milliseconds <= 0L || milliseconds >= (long)86400000) {
            return "00:00";
        }
        long totalSeconds = milliseconds / (long)1000;
        long seconds = totalSeconds % (long)60;
        long minutes = totalSeconds / (long)60 % (long)60;
        long hours = totalSeconds / (long)3600;
        StringBuilder stringBuilder = new StringBuilder();
        Formatter mFormatter = new Formatter(stringBuilder, Locale.getDefault());
        if (hours > 0L) {
            String string3 = mFormatter.format("%02d:%02d:%02d", hours, minutes, seconds).toString();
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"mFormatter.format(\"%02d:\u2026utes, seconds).toString()");
        } else {
            String string4 = mFormatter.format("%02d:%02d", minutes, seconds).toString();
            string2 = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"mFormatter.format(\"%02d:\u2026utes, seconds).toString()");
        }
        return string2;
    }

    public final void savePlayPosition(@NotNull Context context, @Nullable Uri uri, long position) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Uri uri2 = uri;
            if (uri2 == null) break block0;
            Uri uri3 = uri2;
            boolean bl = false;
            boolean bl2 = false;
            Uri it = uri3;
            boolean bl3 = false;
            context.getSharedPreferences("FIVE_FIVE_VIDEO_PALYER_PLAY_POSITION", 0).edit().putLong(it.toString(), position).apply();
        }
    }

    public final long getSavedPlayPosition(@NotNull Context context, @Nullable Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Uri uri2 = uri;
        if (uri2 != null) {
            Uri uri3 = uri2;
            boolean bl = false;
            boolean bl2 = false;
            Uri it = uri3;
            boolean bl3 = false;
            return context.getSharedPreferences("FIVE_FIVE_VIDEO_PALYER_PLAY_POSITION", 0).getLong(it.toString(), 0L);
        }
        return 0L;
    }

    private VideoUtils() {
    }

    static {
        VideoUtils videoUtils;
        INSTANCE = videoUtils = new VideoUtils();
        mSystemUiVisibilityPortrait = -1;
    }
}

