/*
 * Decompiled with CFR 0.152.
 */
package cn.onestravel.fivefiveplayer.impl;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.net.Uri;
import android.os.Handler;
import androidx.annotation.RequiresApi;
import cn.onestravel.fivefiveplayer.FivePlayer;
import cn.onestravel.fivefiveplayer.MediaDataSource;
import cn.onestravel.fivefiveplayer.interf.PlayerCallBack;
import cn.onestravel.fivefiveplayer.kernel.MediaKernelApi;
import cn.onestravel.fivefiveplayer.kernel.MediaKernelInterface;
import cn.onestravel.fivefiveplayer.kernel.MediaPlayerKernel;
import cn.onestravel.fivefiveplayer.utils.LogHelper;
import cn.onestravel.fivefiveplayer.utils.VideoUtils;
import cn.onestravel.fivefiveplayer.view.VideoTextureView;
import java.lang.reflect.Constructor;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u0016J\u0006\u0010 \u001a\u00020\nJ\u0006\u0010!\u001a\u00020\nJ\u0006\u0010\"\u001a\u00020\nJ\u0018\u0010#\u001a\u00020$2\u000e\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0&H\u0002J\u0006\u0010'\u001a\u00020\u001aJ\u0006\u0010(\u001a\u00020\u001aJ\u000e\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u0016J\u0006\u0010+\u001a\u00020\u001aJ\u0012\u0010,\u001a\u00020\u001a2\n\u0010-\u001a\u00060.j\u0002`/J\u0006\u00100\u001a\u00020\u001aJ\u0006\u00101\u001a\u00020\u001aJ\u0006\u00102\u001a\u00020\u001aJ\u0016\u00103\u001a\u00020\u001a2\u0006\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u001dJ\b\u00106\u001a\u00020\u001aH\u0002J\u0006\u00107\u001a\u00020\u001aJ\u000e\u00108\u001a\u00020\u001a2\u0006\u00109\u001a\u00020\u001dJ\u0006\u0010:\u001a\u00020\u001aJ\u0006\u0010;\u001a\u00020\u001aJ\u0016\u0010<\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020\u00162\u0006\u0010>\u001a\u00020\u0016J\u0006\u0010?\u001a\u00020\u001aJ\u0006\u0010@\u001a\u00020\u001aJ\u0006\u0010A\u001a\u00020\u001aJ\u0006\u0010B\u001a\u00020\u001aJ\u000e\u0010C\u001a\u00020\u001a2\u0006\u00109\u001a\u00020\u001dJ\u000e\u0010D\u001a\u00020\u001a2\u0006\u0010E\u001a\u00020\fJ\u000e\u0010D\u001a\u00020\u001a2\u0006\u0010F\u001a\u00020\u0006J\u0016\u0010G\u001a\u00020\u001a2\u000e\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0&J\u000e\u0010H\u001a\u00020\u001a2\u0006\u0010I\u001a\u00020\u0010J\u000e\u0010J\u001a\u00020\u001a2\u0006\u0010K\u001a\u00020LJ\u0010\u0010M\u001a\u00020\u001a2\u0006\u0010N\u001a\u00020OH\u0007J\u0016\u0010P\u001a\u00020\u001a2\u0006\u0010Q\u001a\u00020L2\u0006\u0010R\u001a\u00020LJ\u0006\u0010S\u001a\u00020\u001aJ\u000e\u0010S\u001a\u00020\u001a2\u0006\u00109\u001a\u00020\u001dJ\u0006\u0010T\u001a\u00020\u001aR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcn/onestravel/fivefiveplayer/impl/FivePlayerImpl;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "TAG", "", "getContext", "()Landroid/content/Context;", "continuePlayFromPerPosition", "", "mDataSource", "Lcn/onestravel/fivefiveplayer/MediaDataSource;", "mMediaKernel", "Lcn/onestravel/fivefiveplayer/kernel/MediaKernelInterface;", "mPlayerCallBack", "Lcn/onestravel/fivefiveplayer/interf/PlayerCallBack;", "mProgressHandler", "Landroid/os/Handler;", "mProgressTicker", "Ljava/lang/Runnable;", "mState", "", "mTextureView", "Lcn/onestravel/fivefiveplayer/view/VideoTextureView;", "attachTextureView", "", "textureView", "getCurrentPosition", "", "getDuration", "getState", "isCompletion", "isPaused", "isPlaying", "newInstance", "Lcn/onestravel/fivefiveplayer/kernel/MediaKernelApi;", "clazz", "Ljava/lang/Class;", "onBufferingPaused", "onBufferingPlaying", "onBufferingUpdate", "percent", "onCompletion", "onError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onPaused", "onPlaying", "onPrepared", "onProgressChanged", "total", "progress", "onResume", "onSeekComplete", "onSeekTo", "position", "onStartRender", "onStopped", "onVideoSizeChanged", "width", "height", "pause", "release", "reset", "resume", "seekTo", "setDataSource", "dataSource", "url", "setMediaKernel", "setPlayerCallBack", "playerCallBack", "setSpeed", "speed", "", "setSurfaceTexture", "surface", "Landroid/graphics/SurfaceTexture;", "setVolume", "leftVolume", "rightVolume", "start", "stop", "fivefiveplayer_release"})
public final class FivePlayerImpl {
    private final String TAG;
    private MediaDataSource mDataSource;
    private MediaKernelInterface mMediaKernel;
    private int mState;
    private PlayerCallBack mPlayerCallBack;
    private VideoTextureView mTextureView;
    private boolean continuePlayFromPerPosition;
    private final Handler mProgressHandler;
    private final Runnable mProgressTicker;
    @NotNull
    private final Context context;

    public final void attachTextureView(@NotNull VideoTextureView textureView) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)((Object)textureView), (String)"textureView");
            VideoTextureView videoTextureView = this.mTextureView = textureView;
            if (videoTextureView == null) break block0;
            VideoTextureView videoTextureView2 = videoTextureView;
            boolean bl = false;
            boolean bl2 = false;
            VideoTextureView it = videoTextureView2;
            boolean bl3 = false;
            it.setSurfaceTextureListener(this.mMediaKernel);
            it.setOpaque(false);
            it.setActivated(true);
        }
    }

    public final void setPlayerCallBack(@NotNull PlayerCallBack playerCallBack) {
        Intrinsics.checkParameterIsNotNull((Object)playerCallBack, (String)"playerCallBack");
        this.mPlayerCallBack = playerCallBack;
    }

    public final int getState() {
        return this.mState;
    }

    public final void setMediaKernel(@NotNull Class<? extends MediaKernelApi> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        this.mMediaKernel = this.newInstance(clazz);
    }

    private final MediaKernelApi newInstance(Class<? extends MediaKernelApi> clazz) {
        try {
            Class<?> clazz2 = Class.forName(clazz.getName());
            Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"Class.forName(clazz.name)");
            Class<?> cls = clazz2;
            Constructor<?> constructor = cls.getDeclaredConstructor(FivePlayerImpl.class);
            Intrinsics.checkExpressionValueIsNotNull(constructor, (String)"cls.getDeclaredConstruct\u2026vePlayerImpl::class.java)");
            Constructor<?> constructor2 = constructor;
            Object obj = constructor2.newInstance(this);
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type cn.onestravel.fivefiveplayer.kernel.MediaKernelApi");
            }
            return (MediaKernelApi)obj;
        }
        catch (ClassNotFoundException e) {
            LogHelper.INSTANCE.e(this.TAG, ' ' + clazz.getSimpleName() + " class not found", e);
        }
        catch (Exception e) {
            LogHelper.INSTANCE.e(this.TAG, "init " + clazz.getSimpleName() + " object error", e);
        }
        return new MediaPlayerKernel(this);
    }

    public final void setDataSource(@NotNull String url) {
        block1: {
            Uri uri;
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Uri uri2 = uri = Uri.parse((String)url);
            if (uri2 == null) break block1;
            Uri uri3 = uri2;
            boolean bl = false;
            boolean bl2 = false;
            Uri it = uri3;
            boolean bl3 = false;
            this.mDataSource = new MediaDataSource(it);
            this.mMediaKernel.release();
            MediaDataSource mediaDataSource = this.mDataSource;
            if (mediaDataSource == null) {
                Intrinsics.throwNpe();
            }
            this.mMediaKernel.prepare(mediaDataSource);
            this.mState = 1;
        }
    }

    public final void setDataSource(@NotNull MediaDataSource dataSource) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        MediaDataSource mediaDataSource = dataSource;
        boolean bl = false;
        boolean bl2 = false;
        MediaDataSource it = mediaDataSource;
        boolean bl3 = false;
        this.mDataSource = it;
        this.mMediaKernel.release();
        this.mMediaKernel.prepare(it);
        this.mState = 1;
    }

    public final void start() {
        if (this.mState == 2 || this.mState == 6 || this.mState == 8) {
            MediaDataSource mediaDataSource = this.mDataSource;
            long position = VideoUtils.INSTANCE.getSavedPlayPosition(this.context, (Uri)(mediaDataSource != null ? mediaDataSource.getUri() : null));
            if (position > (long)20) {
                this.seekTo(position - (long)20);
            }
            this.mMediaKernel.start();
            this.onPlaying();
        }
    }

    public final void start(long position) {
        if (this.mState == 2 || this.mState == 6 || this.mState == 8) {
            this.mMediaKernel.start(position);
            this.onPlaying();
        }
    }

    public final void pause() {
        if (this.mState == 5 || this.mState == 3) {
            MediaDataSource mediaDataSource = this.mDataSource;
            VideoUtils.INSTANCE.savePlayPosition(this.context, (Uri)(mediaDataSource != null ? mediaDataSource.getUri() : null), this.getCurrentPosition());
            this.mMediaKernel.pause();
            this.onPaused();
        }
    }

    public final void stop() {
        if (this.mState == 5 || this.mState == 3) {
            MediaDataSource mediaDataSource = this.mDataSource;
            VideoUtils.INSTANCE.savePlayPosition(this.context, (Uri)(mediaDataSource != null ? mediaDataSource.getUri() : null), this.getCurrentPosition());
            this.mMediaKernel.stop();
            this.onStopped();
        }
    }

    public final void resume() {
        if (this.mState == 6 || this.mState == 4) {
            MediaDataSource mediaDataSource = this.mDataSource;
            long position = VideoUtils.INSTANCE.getSavedPlayPosition(this.context, (Uri)(mediaDataSource != null ? mediaDataSource.getUri() : null));
            if (position > 0L) {
                this.seekTo(position);
            }
            this.mMediaKernel.resume();
            this.onResume();
            this.onPlaying();
        }
    }

    public final void seekTo(long position) {
        try {
            if (this.mState != 0 && this.mState != 1 && this.mState != -1) {
                this.mMediaKernel.seekTo(position);
            }
        }
        catch (Exception e) {
            LogHelper.INSTANCE.e(this.TAG, "Five player seekTo error:", e);
        }
    }

    public final long getDuration() {
        try {
            if (this.mState != 0 && this.mState != 1 && this.mState != -1) {
                return this.mMediaKernel.getDuration();
            }
        }
        catch (Exception e) {
            LogHelper.INSTANCE.e(this.TAG, "Five player getDuration error:", e);
        }
        return 0L;
    }

    public final long getCurrentPosition() {
        try {
            if (this.mState != 0 && this.mState != 1 && this.mState != -1) {
                return this.mMediaKernel.getCurrentPosition();
            }
        }
        catch (Exception e) {
            LogHelper.INSTANCE.e(this.TAG, "Five player getDuration error:", e);
        }
        return 0L;
    }

    public final boolean isPlaying() {
        boolean isPlaying = false;
        try {
            if (this.mState != 0 && this.mState != 1 && this.mState != -1) {
                isPlaying = this.mMediaKernel.isPlaying();
            }
        }
        catch (Exception e) {
            LogHelper.INSTANCE.e(this.TAG, "Five player isPlaying error:", e);
        }
        return isPlaying && this.mState == 5;
    }

    public final boolean isPaused() {
        return this.mState == 6;
    }

    public final boolean isCompletion() {
        return this.mState == 8;
    }

    public final void setVolume(float leftVolume, float rightVolume) {
        try {
            this.mMediaKernel.setVolume(leftVolume, rightVolume);
        }
        catch (Exception e) {
            LogHelper.INSTANCE.e(this.TAG, "Five player change volume error:", e);
        }
    }

    public final void setSpeed(float speed) {
        try {
            if (this.mState != 0 && this.mState != 1 && this.mState != -1) {
                this.mMediaKernel.setSpeed(speed);
            }
        }
        catch (Exception e) {
            LogHelper.INSTANCE.e(this.TAG, "Five player change speed error:", e);
        }
    }

    @RequiresApi(value=16)
    public final void setSurfaceTexture(@NotNull SurfaceTexture surface) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)surface, (String)"surface");
            LogHelper.INSTANCE.e("==================", "setSurfaceTexture");
            PlayerCallBack playerCallBack = this.mPlayerCallBack;
            if (playerCallBack == null) break block0;
            PlayerCallBack playerCallBack2 = playerCallBack;
            boolean bl = false;
            boolean bl2 = false;
            PlayerCallBack it = playerCallBack2;
            boolean bl3 = false;
            it.onSetSurfaceTexture(surface);
        }
    }

    public final void reset() {
        try {
            this.mState = 0;
            this.mProgressHandler.removeCallbacks(this.mProgressTicker);
            MediaDataSource mediaDataSource = this.mDataSource;
            VideoUtils.INSTANCE.savePlayPosition(this.context, (Uri)(mediaDataSource != null ? mediaDataSource.getUri() : null), 0L);
            this.mMediaKernel.stop();
            this.mMediaKernel.reset();
        }
        catch (Exception e) {
            LogHelper.INSTANCE.e(this.TAG, "Five player reset error:", e);
        }
    }

    public final void release() {
        try {
            this.mState = 0;
            this.mProgressHandler.removeCallbacks(this.mProgressTicker);
            MediaDataSource mediaDataSource = this.mDataSource;
            VideoUtils.INSTANCE.savePlayPosition(this.context, (Uri)(mediaDataSource != null ? mediaDataSource.getUri() : null), 0L);
            this.mMediaKernel.stop();
            this.mMediaKernel.release();
        }
        catch (Exception e) {
            LogHelper.INSTANCE.e(this.TAG, "Five player release error:", e);
        }
    }

    public final void onPrepared() {
        block1: {
            this.mState = 2;
            boolean continuePlay = this.continuePlayFromPerPosition;
            this.start();
            if (!continuePlay) {
                this.pause();
            }
            PlayerCallBack playerCallBack = this.mPlayerCallBack;
            if (playerCallBack == null) break block1;
            PlayerCallBack playerCallBack2 = playerCallBack;
            boolean bl = false;
            boolean bl2 = false;
            PlayerCallBack it = playerCallBack2;
            boolean bl3 = false;
            it.onPrepared();
        }
    }

    public final void onStartRender() {
        if (this.mState == 2) {
            this.mState = 5;
        }
        PlayerCallBack playerCallBack = this.mPlayerCallBack;
        if (playerCallBack != null) {
            PlayerCallBack playerCallBack2 = playerCallBack;
            boolean bl = false;
            boolean bl2 = false;
            PlayerCallBack it = playerCallBack2;
            boolean bl3 = false;
            it.onStart(true);
        }
        this.onPlaying();
    }

    public final void onStopped() {
        block0: {
            this.continuePlayFromPerPosition = false;
            this.mState = 7;
            this.mProgressHandler.removeCallbacks(this.mProgressTicker);
            PlayerCallBack playerCallBack = this.mPlayerCallBack;
            if (playerCallBack == null) break block0;
            PlayerCallBack playerCallBack2 = playerCallBack;
            boolean bl = false;
            boolean bl2 = false;
            PlayerCallBack it = playerCallBack2;
            boolean bl3 = false;
            it.onStopped();
        }
    }

    public final void onPaused() {
        block0: {
            this.continuePlayFromPerPosition = false;
            this.mState = 6;
            this.mProgressHandler.removeCallbacks(this.mProgressTicker);
            PlayerCallBack playerCallBack = this.mPlayerCallBack;
            if (playerCallBack == null) break block0;
            PlayerCallBack playerCallBack2 = playerCallBack;
            boolean bl = false;
            boolean bl2 = false;
            PlayerCallBack it = playerCallBack2;
            boolean bl3 = false;
            it.onPaused();
        }
    }

    private final void onResume() {
        block0: {
            this.continuePlayFromPerPosition = true;
            PlayerCallBack playerCallBack = this.mPlayerCallBack;
            if (playerCallBack == null) break block0;
            PlayerCallBack playerCallBack2 = playerCallBack;
            boolean bl = false;
            boolean bl2 = false;
            PlayerCallBack it = playerCallBack2;
            boolean bl3 = false;
            it.onResume();
        }
    }

    public final void onBufferingPlaying() {
        block0: {
            this.mState = 3;
            PlayerCallBack playerCallBack = this.mPlayerCallBack;
            if (playerCallBack == null) break block0;
            PlayerCallBack playerCallBack2 = playerCallBack;
            boolean bl = false;
            boolean bl2 = false;
            PlayerCallBack it = playerCallBack2;
            boolean bl3 = false;
            it.onBufferingPlaying();
        }
    }

    public final void onBufferingPaused() {
        block0: {
            this.mState = 4;
            this.mProgressHandler.removeCallbacks(this.mProgressTicker);
            PlayerCallBack playerCallBack = this.mPlayerCallBack;
            if (playerCallBack == null) break block0;
            PlayerCallBack playerCallBack2 = playerCallBack;
            boolean bl = false;
            boolean bl2 = false;
            PlayerCallBack it = playerCallBack2;
            boolean bl3 = false;
            it.onBufferingPaused();
        }
    }

    public final void onPlaying() {
        block0: {
            this.mState = 5;
            this.continuePlayFromPerPosition = true;
            this.mProgressHandler.post(this.mProgressTicker);
            PlayerCallBack playerCallBack = this.mPlayerCallBack;
            if (playerCallBack == null) break block0;
            PlayerCallBack playerCallBack2 = playerCallBack;
            boolean bl = false;
            boolean bl2 = false;
            PlayerCallBack it = playerCallBack2;
            boolean bl3 = false;
            it.onPlaying();
        }
    }

    public final void onSeekTo(long position) {
        block0: {
            PlayerCallBack playerCallBack = this.mPlayerCallBack;
            if (playerCallBack == null) break block0;
            PlayerCallBack playerCallBack2 = playerCallBack;
            boolean bl = false;
            boolean bl2 = false;
            PlayerCallBack it = playerCallBack2;
            boolean bl3 = false;
            it.onSeekTo(position);
        }
    }

    public final void onSeekComplete() {
        this.onSeekTo(this.getCurrentPosition());
    }

    public final void onBufferingUpdate(int percent) {
        block0: {
            PlayerCallBack playerCallBack = this.mPlayerCallBack;
            if (playerCallBack == null) break block0;
            PlayerCallBack playerCallBack2 = playerCallBack;
            boolean bl = false;
            boolean bl2 = false;
            PlayerCallBack it = playerCallBack2;
            boolean bl3 = false;
        }
    }

    public final void onProgressChanged(long total, long progress) {
        block0: {
            PlayerCallBack playerCallBack = this.mPlayerCallBack;
            if (playerCallBack == null) break block0;
            PlayerCallBack playerCallBack2 = playerCallBack;
            boolean bl = false;
            boolean bl2 = false;
            PlayerCallBack it = playerCallBack2;
            boolean bl3 = false;
            it.onProgressChanged(total, progress);
        }
    }

    public final void onCompletion() {
        this.onProgressChanged(this.getDuration(), this.getCurrentPosition());
        this.continuePlayFromPerPosition = false;
        this.mState = 8;
        PlayerCallBack playerCallBack = this.mPlayerCallBack;
        if (playerCallBack != null) {
            PlayerCallBack playerCallBack2 = playerCallBack;
            boolean bl = false;
            boolean bl2 = false;
            PlayerCallBack it = playerCallBack2;
            boolean bl3 = false;
            it.onCompletion();
        }
        this.mProgressHandler.removeCallbacks(this.mProgressTicker);
        MediaDataSource mediaDataSource = this.mDataSource;
        VideoUtils.INSTANCE.savePlayPosition(this.context, (Uri)(mediaDataSource != null ? mediaDataSource.getUri() : null), 0L);
    }

    public final void onError(@NotNull Exception e) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            this.continuePlayFromPerPosition = false;
            this.mState = -1;
            String string2 = this.mMediaKernel.getClass().getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"mMediaKernel.javaClass.simpleName");
            LogHelper.INSTANCE.e(string2, "Player Exception:", e);
            PlayerCallBack playerCallBack = this.mPlayerCallBack;
            if (playerCallBack == null) break block0;
            PlayerCallBack playerCallBack2 = playerCallBack;
            boolean bl = false;
            boolean bl2 = false;
            PlayerCallBack it = playerCallBack2;
            boolean bl3 = false;
            it.onError(e);
        }
    }

    public final void onVideoSizeChanged(int width, int height) {
        block1: {
            VideoTextureView it;
            boolean bl;
            boolean bl2;
            Object object;
            VideoTextureView videoTextureView = this.mTextureView;
            if (videoTextureView != null) {
                object = videoTextureView;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl3 = false;
                it.resetVideoSize(width, height);
            }
            PlayerCallBack playerCallBack = this.mPlayerCallBack;
            if (playerCallBack == null) break block1;
            object = playerCallBack;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl4 = false;
            it.onVideoSizeChanged(width, height);
        }
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public FivePlayerImpl(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"javaClass.simpleName");
        this.TAG = string2;
        this.mMediaKernel = this.newInstance(FivePlayer.INSTANCE.getMediaKernelClass());
        this.mProgressHandler = new Handler();
        this.mProgressTicker = new Runnable(this){
            final /* synthetic */ FivePlayerImpl this$0;

            public void run() {
                FivePlayerImpl.access$getMProgressHandler$p(this.this$0).postDelayed((Runnable)this, 200L);
                this.this$0.onProgressChanged(this.this$0.getDuration(), this.this$0.getCurrentPosition());
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public static final /* synthetic */ Handler access$getMProgressHandler$p(FivePlayerImpl $this) {
        return $this.mProgressHandler;
    }
}

