/*
 * Decompiled with CFR 0.152.
 */
package cn.okayj.axui.preordertreeadapter;

import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import cn.okayj.axui.preordertreeadapter.AdapterBridge;
import cn.okayj.axui.preordertreeadapter.LinearDataSource;
import cn.okayj.axui.preordertreeadapter.ListViewAdapter;
import cn.okayj.axui.preordertreeadapter.RecyclerViewAdapter;
import cn.okayj.axui.viewholder.ViewHolder;
import cn.okayj.util.lineartree.DataNode;
import cn.okayj.util.lineartree.NodeFlatIndex;

public abstract class PreOrderTreeAdapter<N, VH extends ViewHolder>
implements LinearDataSource<VH> {
    private AdapterBridge<VH> realAdapter;
    private DataNode<N> rootNode;
    private NodeFlatIndex nodeFlatIndex;
    private N source;

    protected abstract N root();

    protected boolean ignoreRoot() {
        return true;
    }

    protected abstract int getChildSize(N var1);

    protected abstract N getChild(N var1, int var2);

    protected abstract int getViewTypeCount();

    protected abstract int getViewType(N var1, int var2);

    protected abstract VH onCreateViewHolder(ViewGroup var1, int var2);

    protected abstract void onBindViewHolder(VH var1, N var2);

    protected int getItemId(N data) {
        return 0;
    }

    public ListAdapter asListAdapter() {
        if (this.realAdapter != null && this.realAdapter instanceof ListAdapter) {
            return (ListAdapter)this.realAdapter;
        }
        ListViewAdapter listAdapter = new ListViewAdapter(this);
        this.realAdapter = listAdapter;
        this.buildModel();
        return listAdapter;
    }

    public RecyclerView.Adapter asRecyclerAdapter() {
        if (this.realAdapter != null && this.realAdapter instanceof RecyclerView.Adapter) {
            return (RecyclerView.Adapter)this.realAdapter;
        }
        RecyclerViewAdapter adapter = new RecyclerViewAdapter(this);
        this.realAdapter = adapter;
        this.buildModel();
        return adapter;
    }

    public boolean notifyChildAdded(N parent, N child, int positionInParent) {
        DataNode<N> node = this.findNode(parent);
        if (node == null) {
            return false;
        }
        if (node == this.rootNode) {
            DataNode<N> newOne = this.buildSubTree(child);
            this.rootNode.addChildNode(positionInParent, newOne);
        } else {
            DataNode<N> newOne = this.buildSubTree(child);
            node.addChildNode(positionInParent, newOne);
        }
        this.realAdapter.notifyDataSetChanged();
        return true;
    }

    public boolean notifyChildRemoved(N child) {
        DataNode<N> node = this.findNode(child);
        if (node == null) {
            return false;
        }
        if (node == this.rootNode) {
            this.clearData();
        } else {
            node.removeFromParent();
        }
        this.realAdapter.notifyDataSetChanged();
        return true;
    }

    public void notifyDataSetChanged() {
        this.buildModel();
        this.realAdapter.notifyDataSetChanged();
    }

    public void notifyDataSetChanged(N subTree) {
        DataNode<N> node = this.findNode(subTree);
        if (node == null) {
            return;
        }
        if (node == this.rootNode) {
            this.notifyDataSetChanged();
            return;
        }
        DataNode parent = node.getParentNode();
        int position = parent.removeChildNode(node);
        assert (position >= 0);
        parent.addChildNode(position, this.buildSubTree(subTree));
        this.realAdapter.notifyDataSetChanged();
    }

    public void notifyDataStateChanged() {
        this.realAdapter.notifyDataSetChanged();
    }

    @Override
    public int count() {
        if (this.nodeFlatIndex == null) {
            return 0;
        }
        return this.nodeFlatIndex.size();
    }

    @Override
    public Object item(int position) {
        return this.nodeFlatIndex.get(position).getSource();
    }

    @Override
    public int itemId(int position) {
        return this.getItemId(this.nodeFlatIndex.get(position).getSource());
    }

    @Override
    public int viewType(int position) {
        DataNode node = this.nodeFlatIndex.get(position);
        int depth = 1;
        DataNode ancestor = node;
        while ((ancestor = ancestor.getParentNode()) != null) {
            ++depth;
        }
        return this.getViewType(node.getSource(), depth);
    }

    @Override
    public int viewTypeCount() {
        return this.getViewTypeCount();
    }

    @Override
    public VH createViewHolder(ViewGroup parent, int viewType) {
        return this.onCreateViewHolder(parent, viewType);
    }

    @Override
    public void bindViewHolder(VH viewHolder, int position) {
        DataNode dataNode = this.nodeFlatIndex.get(position);
        this.onBindViewHolder(viewHolder, dataNode.getSource());
    }

    private DataNode<N> buildSubTree(N data) {
        DataNode node = new DataNode();
        node.setSource(data);
        int childSize = this.getChildSize(data);
        for (int i = 0; i < childSize; ++i) {
            node.addChildNode(this.buildSubTree(this.getChild(data, i)));
        }
        return node;
    }

    private void clearData() {
        this.rootNode = null;
        this.source = null;
        this.nodeFlatIndex = null;
        this.nodeFlatIndex = null;
    }

    public final PreOrderTreeAdapter buildModel() {
        this.clearData();
        this.source = this.root();
        if (this.source != null) {
            this.rootNode = this.buildSubTree(this.source);
            this.nodeFlatIndex = this.rootNode.getFlatIndex();
            if (this.ignoreRoot()) {
                this.nodeFlatIndex.ignoreRoot(true);
            }
        }
        return this;
    }

    private DataNode<N> findNode(N data) {
        if (this.source == data) {
            return this.rootNode;
        }
        for (int i = 0; i < this.nodeFlatIndex.size(); ++i) {
            DataNode node = this.nodeFlatIndex.get(i);
            if (node.getSource() != data) continue;
            return node;
        }
        return null;
    }
}

