/*
 * Decompiled with CFR 0.152.
 */
package cn.microanswer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpUtil {
    public static boolean LOG = true;
    private static Object logger = HttpUtil.getLogger();
    private static String CHARSET = "UTF-8";
    private static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    private static final MediaType APPLICATION_XML = MediaType.parse((String)"application/xml");
    private static final MediaType X_WWW_FORM_URLENCODED = MediaType.parse((String)"application/x-www-form-urlencoded");
    private static OkHttpClient __httpClient;

    private static Object getLogger() {
        try {
            Class<?> aClass = Class.forName("org.slf4j.LoggerFactory");
            Method getLogger = aClass.getDeclaredMethod("getLogger", Class.class);
            getLogger.setAccessible(true);
            return getLogger.invoke(aClass, HttpUtil.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void log(Object logger, String type, String msg) {
        try {
            Method declaredMethod = logger.getClass().getDeclaredMethod(type, String.class);
            declaredMethod.setAccessible(true);
            declaredMethod.invoke(logger, msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static OkHttpClient getHttpClient() {
        if (__httpClient == null) {
            __httpClient = new OkHttpClient.Builder().connectTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).build();
        }
        return __httpClient;
    }

    private static String newRequestId() {
        return UUID.randomUUID().toString().substring(0, 5);
    }

    private static Response _requestForResponse(String requestId, Request request) throws NetException {
        Call call = HttpUtil.getHttpClient().newCall(request);
        Response response = null;
        try {
            response = call.execute();
            if (response.code() != 200) {
                throw new Exception(request.method() + " error:" + request.url() + " [" + response.code() + "] " + response.message());
            }
        }
        catch (Exception e) {
            int code = -1;
            if (response != null) {
                code = response.code();
            }
            throw new NetException(e.getMessage(), code);
        }
        return response;
    }

    private static String _requestForString(String requestId, Request request) throws NetException {
        Response response = HttpUtil._requestForResponse(requestId, request);
        String resStr = "";
        try {
            resStr = response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HttpUtil.info(requestId, "response:" + resStr, null);
        return resStr;
    }

    private static String _makeParamUrl(String requestId, String url, Map<String, String> params) {
        String queryString = HttpUtil.map2wwwUrlFormEncode(params);
        if (queryString.length() > 0) {
            HttpUtil.info(requestId, "send param:" + queryString, null);
            url = url.contains("?") ? url + "&" + queryString : url + "?" + queryString;
        }
        return url;
    }

    private static void _putHearderInRequestBuilder(String requestId, Request.Builder builder, Map<String, String> headers) {
        if (headers != null && headers.size() > 0) {
            Set<Map.Entry<String, String>> entries = headers.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                builder.addHeader(entry.getKey(), entry.getValue());
                HttpUtil.debug(requestId, "send header:" + entry.getKey() + "=" + entry.getValue(), null);
            }
        }
    }

    private static Request _makeGetRequest(String requestId, String url, Map<String, String> params, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder();
        builder.url(HttpUtil._makeParamUrl(requestId, url, params));
        HttpUtil._putHearderInRequestBuilder(requestId, builder, headers);
        builder.get();
        return builder.build();
    }

    private static void mapForEach(Map<String, String> map, Fun<String, String> fun) throws Exception {
        if (map == null || map.size() <= 0 || fun == null) {
            return;
        }
        Set<Map.Entry<String, String>> entries = map.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            fun.d0fun(entry.getKey(), entry.getValue());
        }
    }

    private static void debug(String requestId, String msg, Exception e) {
        if (!LOG) {
            return;
        }
        if (logger != null) {
            HttpUtil.log(logger, "debug", String.format("[%s] %s", requestId, msg));
        }
    }

    private static void info(String requestId, String msg, Exception e) {
        if (!LOG) {
            return;
        }
        if (logger != null) {
            HttpUtil.log(logger, "info", String.format("[%s] %s", requestId, msg));
        }
    }

    private static void error(String requestId, String msg, Exception e) {
        if (!LOG) {
            return;
        }
    }

    private static void warn(String requestId, String msg, Exception e) {
        if (!LOG) {
            return;
        }
    }

    public static String get(String url, Map<String, String> params, Map<String, String> headers) throws Exception {
        String requestId = HttpUtil.newRequestId();
        HttpUtil.info(requestId, "get url:" + url, null);
        return HttpUtil._requestForString(requestId, HttpUtil._makeGetRequest(requestId, url, params, headers));
    }

    public static String get(String url, Map<String, String> params) throws Exception {
        return HttpUtil.get(url, params, null);
    }

    public static String get(String url) throws Exception {
        return HttpUtil.get(url, null);
    }

    public static String post(String url, MediaType contentType, byte[] bodyBytes, Map<String, String> headers) throws Exception {
        String requestId = HttpUtil.newRequestId();
        HttpUtil.info(requestId, "post url:" + url, null);
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        HttpUtil._putHearderInRequestBuilder(requestId, builder, headers);
        builder.post(RequestBody.create((MediaType)contentType, (byte[])bodyBytes));
        Request request = builder.build();
        Call call = HttpUtil.getHttpClient().newCall(request);
        Response response = call.execute();
        if (response.code() != 200) {
            throw new NetException("post error:" + url + " [" + response.code() + "] " + response.message(), response.code());
        }
        String retStr = response.body().string();
        HttpUtil.info(requestId, "response:" + retStr, null);
        return retStr;
    }

    public static String postFormUrlEncode(String url, Map<String, ?> params, Map<String, String> headers) throws Exception {
        return HttpUtil.post(url, X_WWW_FORM_URLENCODED, HttpUtil.map2wwwUrlFormEncode(params).getBytes(CHARSET), headers);
    }

    public static String postFormUrlEncode(String url, Map<String, ?> params) throws Exception {
        return HttpUtil.postFormUrlEncode(url, params, null);
    }

    public static String postApplicationJson(String url, Map<String, ?> params, Map<String, String> headers) throws Exception {
        return HttpUtil.postApplicationJson(url, JSON.toJSONString(params), headers);
    }

    public static String postApplicationJson(String url, Map<String, ?> params) throws Exception {
        return HttpUtil.postApplicationJson(url, params, null);
    }

    public static String postApplicationJson(String url, JSONObject jsonObject, Map<String, String> headers) throws Exception {
        return HttpUtil.postApplicationJson(url, jsonObject.toJSONString(), headers);
    }

    public static String postApplicationJson(String url, JSONObject jsonObject) throws Exception {
        return HttpUtil.postApplicationJson(url, jsonObject.toJSONString(), null);
    }

    public static String postApplicationJson(String url, String jsonStr, Map<String, String> headers) throws Exception {
        return HttpUtil.post(url, APPLICATION_JSON, jsonStr.getBytes(CHARSET), headers);
    }

    public static String postApplicationJson(String url, String jsonStr) throws Exception {
        return HttpUtil.postApplicationJson(url, jsonStr, null);
    }

    public static String postApplicationXml(String url, String xmlStr, Map<String, String> headers) throws Exception {
        return HttpUtil.post(url, APPLICATION_XML, xmlStr.getBytes(CHARSET), headers);
    }

    public static String postApplicationXml(String url, String xmlStr) throws Exception {
        return HttpUtil.postApplicationXml(url, xmlStr, null);
    }

    public static String upload(String url, Map<String, String> params, Map<String, String> headers, File ... files) throws Exception {
        String requestId = HttpUtil.newRequestId();
        HttpUtil.info(requestId, "upload url:" + url, null);
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        HttpUtil._putHearderInRequestBuilder(requestId, builder, headers);
        final MultipartBody.Builder multipartBodyBuilder = new MultipartBody.Builder();
        multipartBodyBuilder.setType(MultipartBody.FORM);
        if (params != null && params.size() > 0) {
            HttpUtil.mapForEach(params, new Fun<String, String>(){

                @Override
                public void d0fun(String key, String value) {
                    multipartBodyBuilder.addFormDataPart(key, value);
                }
            });
        }
        if (files != null && files.length > 0) {
            int index = 0;
            for (File file : files) {
                multipartBodyBuilder.addFormDataPart("file" + (index > 0 ? Integer.valueOf(index) : ""), file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (File)file));
                ++index;
            }
        }
        builder.post((RequestBody)multipartBodyBuilder.build());
        Request request = builder.build();
        Call call = HttpUtil.getHttpClient().newCall(request);
        Response response = call.execute();
        if (response.code() != 200) {
            throw new NetException("upload error:" + url + " [" + response.code() + "] " + response.message(), response.code());
        }
        String retStr = response.body().string();
        HttpUtil.info(requestId, "response:" + retStr, null);
        return retStr;
    }

    public static String upload(String url, Map<String, String> params, File ... files) throws Exception {
        return HttpUtil.upload(url, params, null, files);
    }

    public static String upload(String url, File ... files) throws Exception {
        return HttpUtil.upload(url, null, files);
    }

    public static File download(String url, Map<String, String> params, Map<String, String> headers, File fileOrDir) throws Exception {
        int dataSize;
        String requestId = HttpUtil.newRequestId();
        HttpUtil.info(requestId, "download url:" + url, null);
        Response response = HttpUtil._requestForResponse(requestId, HttpUtil._makeGetRequest(requestId, url, params, headers));
        if (fileOrDir == null || fileOrDir.isDirectory()) {
            String[] split;
            String fileName = "";
            String contentdisposition = response.header("Content-Disposition");
            if (contentdisposition != null && contentdisposition.length() > 0) {
                try {
                    for (String kv : split = contentdisposition.split(";")) {
                        String value;
                        String[] kvs = kv.split("=");
                        kvs[0] = kvs[0].trim();
                        if ("filename*".equalsIgnoreCase(kvs[0]) && (value = kvs[1]) != null && value.length() > 0) {
                            String mCharset = CHARSET;
                            if (value.contains("'")) {
                                String[] strings = value.split("'");
                                mCharset = strings[0];
                                value = URLDecoder.decode(strings[strings.length - 1], mCharset);
                            } else {
                                value = URLDecoder.decode(value, mCharset);
                            }
                            fileName = value;
                        }
                        if (fileName == null || fileName.length() <= 0) {
                            if (!"filename".equalsIgnoreCase(kvs[0])) continue;
                            value = URLDecoder.decode(kvs[1], CHARSET);
                            if (value != null && value.length() > 0) {
                                value = value.replace("\"", "");
                            }
                            fileName = value;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception ignore) {
                    fileName = "";
                }
            }
            if (fileName.length() < 1) {
                split = url.split("\\?")[0].split("/");
                fileName = split[split.length - 1];
            }
            if (fileName.length() < 1) {
                fileName = String.valueOf(System.currentTimeMillis());
            }
            if (!fileName.contains(".")) {
                String fileEnd = response.header("Content-Type");
                fileEnd = fileEnd != null && fileEnd.length() > 0 ? (fileEnd.contains(";") ? fileEnd.substring(fileEnd.indexOf("/") + 1, fileEnd.indexOf(";")) : fileEnd.substring(fileEnd.indexOf("/") + 1)) : "httputildownload";
                fileName = fileName + "." + fileEnd;
            }
            if (fileOrDir == null) {
                File tempDir = new File(System.getProperty("java.io.tmpdir"));
                fileOrDir = new File(tempDir, fileName);
            } else {
                fileOrDir = new File(fileOrDir, fileName);
            }
        }
        InputStream inputStream = response.body().byteStream();
        FileOutputStream outputStream = new FileOutputStream(fileOrDir);
        BufferedOutputStream bfo = new BufferedOutputStream(outputStream);
        byte[] data = new byte[1024];
        while ((dataSize = inputStream.read(data)) != -1) {
            bfo.write(data, 0, dataSize);
        }
        bfo.flush();
        outputStream.flush();
        outputStream.close();
        inputStream.close();
        return fileOrDir;
    }

    public static File download(String url, File fileOrDir) throws Exception {
        return HttpUtil.download(url, null, null, fileOrDir);
    }

    public static File download(String url, String fileOrDirPath) throws Exception {
        return HttpUtil.download(url, new File(fileOrDirPath));
    }

    public static File download(String url) throws Exception {
        return HttpUtil.download(url, (File)null);
    }

    public static String map2wwwUrlFormEncode(Map<String, ?> params, String charSet) {
        if (params == null || params.size() < 1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Set<Map.Entry<String, ?>> entries = params.entrySet();
        for (Map.Entry<String, ?> entry : entries) {
            String value = null;
            try {
                value = URLEncoder.encode(entry.getValue().toString(), charSet);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            stringBuilder.append(entry.getKey()).append("=").append(value).append("&");
        }
        return stringBuilder.toString();
    }

    public static String map2wwwUrlFormEncode(Map<String, ?> params) {
        return HttpUtil.map2wwwUrlFormEncode(params, CHARSET);
    }

    public static class NetException
    extends Exception {
        private int code;

        public NetException(int code) {
            this("net error", code);
        }

        public NetException(String msg, int code) {
            super(msg);
            this.code = code;
        }
    }

    private static interface Fun<A, B> {
        public void d0fun(A var1, B var2) throws Exception;
    }
}

