/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.android.thermometer.ble.utils;

import android.content.Context;
import android.text.TextUtils;
import com.basic.util.ACache;

public class DeviceInformationServiceUtil {
    public static String getSoftwareRevision(byte[] value) {
        if (value == null) {
            return "0.0.0";
        }
        return new String(value);
    }

    public static void setFirmwareVersion(Context context, String version) {
        ACache.get((Context)context).put("FirmwareVersion", version);
    }

    public static String getFirmwareVersion(Context context) {
        String version = ACache.get((Context)context).getAsString("FirmwareVersion");
        if (TextUtils.isEmpty((CharSequence)version)) {
            return "0.0.0";
        }
        return version;
    }

    public static String getHardwareRevision(byte[] value) {
        if (value == null) {
            return "";
        }
        return new String(value);
    }

    public static void setHardwareVersion(Context context, String version) {
        ACache.get((Context)context).put("HardwareVersion", version);
    }

    public static String getHardwareVersion(Context context) {
        return ACache.get((Context)context).getAsString("HardwareVersion");
    }

    public static String getSNRevision(byte[] value) {
        if (value == null) {
            return "";
        }
        return new String(value);
    }

    public static void setSN(Context context, String sn) {
        ACache.get((Context)context).put("sn", sn);
    }

    public static String getSN(Context context) {
        return ACache.get((Context)context).getAsString("sn");
    }

    public static boolean canGetSN(Context context) {
        String[] s;
        String softwareRevision = DeviceInformationServiceUtil.getFirmwareVersion(context);
        if (!TextUtils.isEmpty((CharSequence)softwareRevision) && (s = softwareRevision.split("\\.")).length >= 3) {
            try {
                int major = Integer.parseInt(s[0]);
                if (major >= 2) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean needOta(Context context, String serverVersion, boolean needOTA) {
        if (TextUtils.isEmpty((CharSequence)serverVersion)) {
            return false;
        }
        if (!needOTA) {
            return false;
        }
        String deviceFirmwareRevision = DeviceInformationServiceUtil.getFirmwareVersion(context);
        if (!TextUtils.isEmpty((CharSequence)deviceFirmwareRevision)) {
            deviceFirmwareRevision = deviceFirmwareRevision.toLowerCase();
            String[] deviceFirmwareRevisions = deviceFirmwareRevision.split("\\.");
            String[] serverFirmwareVersions = serverVersion.split("\\.");
            if (deviceFirmwareRevisions.length >= 3 && serverFirmwareVersions.length >= 3) {
                try {
                    int deviceFirmwareRevisionMajor = Integer.parseInt(deviceFirmwareRevisions[0]);
                    int deviceFirmwareRevisionMinor = Integer.parseInt(deviceFirmwareRevisions[1]);
                    int deviceFirmwareRevisionBugFix = Integer.parseInt(deviceFirmwareRevisions[2]);
                    int serverFirmwareVersionMajor = Integer.parseInt(serverFirmwareVersions[0]);
                    int serverFirmwareVersionMinor = Integer.parseInt(serverFirmwareVersions[1]);
                    int serverFirmwareVersionBugFix = Integer.parseInt(serverFirmwareVersions[2]);
                    if (serverFirmwareVersionMajor == deviceFirmwareRevisionMajor && (serverFirmwareVersionMinor > deviceFirmwareRevisionMinor || serverFirmwareVersionMinor == deviceFirmwareRevisionMinor && serverFirmwareVersionBugFix > deviceFirmwareRevisionBugFix)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean canOpenAlarm(Context context) {
        String[] s;
        String softwareRevision = DeviceInformationServiceUtil.getFirmwareVersion(context);
        if (!TextUtils.isEmpty((CharSequence)softwareRevision) && (s = softwareRevision.split("\\.")).length >= 3) {
            try {
                int major = Integer.parseInt(s[0]);
                int minor = Integer.parseInt(s[1]);
                if (major > 1 || minor >= 1) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean canGetDebugInfo(Context context) {
        String[] s;
        String softwareRevision = DeviceInformationServiceUtil.getFirmwareVersion(context);
        if (!TextUtils.isEmpty((CharSequence)softwareRevision) && (s = softwareRevision.split("\\.")).length >= 3) {
            try {
                int major = Integer.parseInt(s[0]);
                int minor = Integer.parseInt(s[1]);
                int bugFix = Integer.parseInt(s[2]);
                if (major > 3) {
                    return true;
                }
                if (major == 3) {
                    if (minor > 1) {
                        return true;
                    }
                    if (minor == 1 && bugFix >= 3) {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

