/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.android.thermometer.ble.utils;

import cn.lollypop.android.thermometer.ble.exceptions.BleException;
import cn.lollypop.android.thermometer.ble.model.AlarmTimeModel;
import java.util.Calendar;
import java.util.Date;

public class AlarmTimeServiceUtil {
    public static Date getThermometerSystemTime(byte[] bs) throws BleException {
        if (bs == null || bs.length != 10) {
            throw new BleException("alarm time length error");
        }
        int year = bs[0] + 2000;
        Calendar c = Calendar.getInstance();
        c.set(year, bs[1], bs[2], bs[4], bs[5], bs[6]);
        return c.getTime();
    }

    public static int getAlarmWeek(byte[] bs) throws BleException {
        if (bs == null || bs.length != 10) {
            throw new BleException("alarm time length error");
        }
        return bs[7];
    }

    public static int getAlarmHour(byte[] bs) throws BleException {
        if (bs == null || bs.length != 10) {
            throw new BleException("alarm time length error");
        }
        return bs[8];
    }

    public static int getAlarmMin(byte[] bs) throws BleException {
        if (bs == null || bs.length != 10) {
            throw new BleException("alarm time length error");
        }
        return bs[9];
    }

    public static byte[] generateSendData(AlarmTimeModel temp) {
        if (temp == null) {
            return new byte[]{0, 0, 0};
        }
        return temp.generateAlarm();
    }
}

