/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.android.thermometer.ble.model;

import android.content.Context;
import android.text.TextUtils;
import com.basic.util.ACache;
import com.basic.util.CommonUtil;
import com.basic.util.GsonUtil;
import java.util.Calendar;
import java.util.Date;

public class AlarmTimeModel {
    public static int EVERY_DAY = 1;
    private static int NO_DAY = 0;
    private int alarmWeek;
    private int alarmHour;
    private int alarmMin;
    private boolean isSelected;

    public AlarmTimeModel(int alarmWeek, int alarmHour, int alarmMin, boolean isSelected) {
        this.alarmWeek = alarmWeek;
        this.alarmHour = alarmHour;
        this.alarmMin = alarmMin;
        this.isSelected = isSelected;
    }

    public static byte[] generateSystemTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Integer year = c.get(1);
        year = year % 2000;
        Integer month = c.get(2) + 1;
        Integer day = c.get(5);
        Integer week = c.get(7) - 1;
        Integer hour = c.get(11);
        Integer min = c.get(12);
        Integer second = c.get(13);
        return new byte[]{year.byteValue(), month.byteValue(), day.byteValue(), week.byteValue(), hour.byteValue(), min.byteValue(), second.byteValue()};
    }

    public byte[] generateAlarm() {
        return new byte[]{(byte)this.alarmWeek, (byte)this.alarmHour, (byte)this.alarmMin};
    }

    public static AlarmTimeModel getSingle(Context context) {
        String json = ACache.get((Context)context).getAsString("AlarmTimeModel");
        AlarmTimeModel alarmTimeModel = TextUtils.isEmpty((CharSequence)json) ? new AlarmTimeModel(NO_DAY, 8, 0, false) : (AlarmTimeModel)GsonUtil.getGson().fromJson(json, AlarmTimeModel.class);
        return alarmTimeModel;
    }

    public static void updateSingle(Context context, int week, int hour, int min) {
        AlarmTimeModel alarmTimeModel = AlarmTimeModel.getSingle(context);
        alarmTimeModel.setAlarmWeek(week);
        alarmTimeModel.setAlarmHour(hour);
        alarmTimeModel.setAlarmMin(min);
        String json = GsonUtil.getGson().toJson((Object)alarmTimeModel);
        ACache.get((Context)context).put("AlarmTimeModel", json);
    }

    public static String getShow(AlarmTimeModel alarmTimeModel) {
        if (alarmTimeModel != null) {
            return CommonUtil.convert10ToString((int)alarmTimeModel.getAlarmHour()) + ":" + CommonUtil.convert10ToString((int)alarmTimeModel.getAlarmMin());
        }
        return "NA";
    }

    public int getAlarmWeek() {
        return this.alarmWeek;
    }

    public void setAlarmWeek(int alarmWeek) {
        this.alarmWeek = alarmWeek;
    }

    public int getAlarmHour() {
        return this.alarmHour;
    }

    public void setAlarmHour(int alarmHour) {
        this.alarmHour = alarmHour;
    }

    public int getAlarmMin() {
        return this.alarmMin;
    }

    public void setAlarmMin(int alarmMin) {
        this.alarmMin = alarmMin;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setIsSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public String toString() {
        return "AlarmTimeModel{alarmWeek=" + this.alarmWeek + ", alarmHour=" + this.alarmHour + ", alarmMin=" + this.alarmMin + ", isSelected=" + this.isSelected + '}';
    }
}

