/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.android.thermometer.ble.action.request;

import android.content.Context;
import cn.lollypop.android.thermometer.ble.Constants;
import cn.lollypop.android.thermometer.ble.action.request.BleRequest;
import cn.lollypop.android.thermometer.ble.action.request.BleRequestActionType;
import cn.lollypop.android.thermometer.ble.action.request.BleRequestValueType;
import cn.lollypop.android.thermometer.ble.utils.CurrentTimeServiceUtil;
import com.orhanobut.logger.Logger;

public class CurrentTimeReadRequest
extends BleRequest {
    private int currentTime;

    public CurrentTimeReadRequest(int currentTime) {
        this.characteristicUUID = Constants.UUID_CURRENT_TIME;
        this.actionType = BleRequestActionType.READ;
        this.valueType = BleRequestValueType.NO_VALUE;
        this.currentTime = currentTime;
    }

    @Override
    public boolean analyzeData(Context context, byte[] data) {
        int timestamp = CurrentTimeServiceUtil.getTimestamp(data);
        int interval = Math.abs(this.currentTime - timestamp);
        Logger.i((String)("ble get current time data : " + timestamp + " , " + "set current time data : " + this.currentTime + " , interval : " + interval), (Object[])new Object[0]);
        if (interval <= 300) {
            Logger.i((String)"ble set current time successfully\uff01", (Object[])new Object[0]);
            return true;
        }
        Logger.i((String)"ble set current time failed\uff01", (Object[])new Object[0]);
        return false;
    }
}

