/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.android.thermometer.ble.action;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import cn.lollypop.android.thermometer.ble.BleAutoConnect;
import cn.lollypop.android.thermometer.ble.GattAttributes;
import cn.lollypop.android.thermometer.ble.action.request.BleRequest;
import cn.lollypop.android.thermometer.ble.action.request.BleRequestActionType;
import cn.lollypop.android.thermometer.ble.action.request.BleRequestValueType;
import cn.lollypop.android.thermometer.ble.action.response.BleResponse;
import com.orhanobut.logger.Logger;
import java.util.Map;
import java.util.UUID;

public class BleGattInteraction {
    public boolean doInteractive(BluetoothGatt bluetoothGatt, BleRequest bleRequest, Map<UUID, BluetoothGattCharacteristic> characteristics, BleAutoConnect.IResponse response) {
        BluetoothGattCharacteristic characteristic = characteristics.get(bleRequest.getCharacteristicUUID());
        if (characteristic == null) {
            return false;
        }
        if (bleRequest.getValueType().equals((Object)BleRequestValueType.BYTE)) {
            characteristic.setValue(bleRequest.getValue());
        } else if (bleRequest.getValueType().equals((Object)BleRequestValueType.UINT16)) {
            characteristic.setValue(bleRequest.getValueInt(), 18, bleRequest.getOffset());
        }
        if (bleRequest.getActionType().equals((Object)BleRequestActionType.READ)) {
            this.readCharacteristic(bluetoothGatt, characteristic);
        } else if (bleRequest.getActionType().equals((Object)BleRequestActionType.WRITE)) {
            this.writeCharacteristic(bluetoothGatt, characteristic);
        } else if (bleRequest.getActionType().equals((Object)BleRequestActionType.SET_NOTIFICATION)) {
            boolean setNotification = this.setCharacteristicNotification(bluetoothGatt, characteristic, bleRequest.isValueBoolean());
            BleResponse bleResponse = new BleResponse(characteristic, setNotification ? 1 : 0);
            response.receiveDataFromDevice("cn.lollypop.android.thermometer.ble.ACTION_GATT_WRITE", bleResponse);
        } else if (bleRequest.getActionType().equals((Object)BleRequestActionType.SET_INDICATION)) {
            this.setIndication(bluetoothGatt, characteristic, bleRequest.getValue());
        }
        return true;
    }

    private void readCharacteristic(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic characteristic) {
        if (bluetoothGatt == null) {
            Logger.e((String)"bluetoothGatt is null", (Object[])new Object[0]);
            return;
        }
        bluetoothGatt.readCharacteristic(characteristic);
    }

    private void writeCharacteristic(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic characteristic) {
        if (bluetoothGatt == null) {
            Logger.e((String)"bluetoothGatt is null", (Object[])new Object[0]);
            return;
        }
        bluetoothGatt.writeCharacteristic(characteristic);
    }

    private boolean setCharacteristicNotification(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic c, boolean enabled) {
        if (bluetoothGatt == null) {
            Logger.e((String)"bluetoothGatt is null", (Object[])new Object[0]);
            return false;
        }
        return bluetoothGatt.setCharacteristicNotification(c, enabled);
    }

    private void setIndication(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic characteristic, byte[] value) {
        if (bluetoothGatt == null) {
            Logger.e((String)"bluetoothGatt is null", (Object[])new Object[0]);
            return;
        }
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(UUID.fromString(GattAttributes.CLIENT_CHARACTERISTIC_CONFIG));
        descriptor.setValue(value);
        bluetoothGatt.writeDescriptor(descriptor);
    }
}

