/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.android.thermometer.ble.action;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.Handler;
import cn.lollypop.android.thermometer.ble.BleAutoConnect;
import cn.lollypop.android.thermometer.ble.BleCallback;
import cn.lollypop.android.thermometer.ble.Constants;
import cn.lollypop.android.thermometer.ble.action.BleGattInteraction;
import cn.lollypop.android.thermometer.ble.action.IBleAction;
import cn.lollypop.android.thermometer.ble.action.request.BleRequest;
import cn.lollypop.android.thermometer.ble.model.AlarmTimeModel;
import com.basic.util.Callback;
import com.orhanobut.logger.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BleActionManager {
    private static final int RE_DO_ACTION_MAX = 3;
    private BleRequest curBleRequest;
    private int reDoActionCount;
    private Context context;
    private final List<BleRequest> bleRequestList = new ArrayList<BleRequest>();
    private final BleGattInteraction bleGattInteraction = new BleGattInteraction();
    private final Map<UUID, BluetoothGattCharacteristic> characteristics = new HashMap<UUID, BluetoothGattCharacteristic>();
    private final Handler timeoutHandler = new Handler();
    private IBleAction bleAction;
    private BleAutoConnect.IResponse response;
    private BluetoothGatt bluetoothGatt;
    private Runnable timeoutRunnable = new Runnable(){

        @Override
        public void run() {
            BleActionManager.this.clearRequest();
            BleActionManager.this.response.refreshView(BleCallback.BleStatus.OPERATE_FAIL);
        }
    };

    public BleActionManager(Context service, BleAutoConnect.IResponse response, IBleAction bleAction) {
        this.context = service;
        this.response = response;
        this.bleAction = bleAction;
    }

    public void start(BluetoothGatt bluetoothGatt, boolean switchOriginalTemperature, Callback callback) {
        this.bluetoothGatt = bluetoothGatt;
        this.handlerGattServices(bluetoothGatt.getServices(), callback);
        this.clearRequest();
        this.bleRequestList.addAll(this.bleAction.initConnect(this.context, switchOriginalTemperature));
        this.doAction();
        this.timeoutHandler.postDelayed(this.timeoutRunnable, 60000L);
    }

    private void handlerGattServices(List<BluetoothGattService> gattServices, Callback callback) {
        if (gattServices == null) {
            return;
        }
        this.characteristics.clear();
        for (BluetoothGattService gattService : gattServices) {
            if (Constants.UUID_HEALTH_THERMOMETER_SERVICE.equals(gattService.getUuid()) || Constants.UUID_BATTERY_SERVICE.equals(gattService.getUuid()) || Constants.UUID_CUSTOM_SERVICE.equals(gattService.getUuid()) || Constants.UUID_CURRENT_TIME_SERVICE.equals(gattService.getUuid()) || Constants.UUID_DEVICE_INFORMATION_SERVICE.equals(gattService.getUuid()) || Constants.UUID_REFERENCE_TIME_UPDATE_SERVICE.equals(gattService.getUuid())) {
                for (BluetoothGattCharacteristic characteristic : gattService.getCharacteristics()) {
                    this.characteristics.put(characteristic.getUuid(), characteristic);
                }
            }
            callback.doCallback(Boolean.valueOf(true), (Object)gattService);
        }
    }

    public void end() {
        this.clearRequest();
    }

    public void clearRequest() {
        this.bleRequestList.clear();
        this.curBleRequest = null;
        this.reDoActionCount = 0;
    }

    public void startMeasure(boolean switchOriginalTemperature) {
        this.bleRequestList.addAll(this.bleAction.startMeasure(switchOriginalTemperature));
        this.doAction();
    }

    public void setAlarm(AlarmTimeModel alarmTimeModel) {
        this.bleRequestList.addAll(this.bleAction.setAlarm(alarmTimeModel));
        this.doAction();
    }

    public void getBatteryLevel() {
        this.bleRequestList.addAll(this.bleAction.getBatteryLevel());
        this.doAction();
    }

    public void doOta() {
        this.bleRequestList.addAll(this.bleAction.doOta());
        this.doAction();
    }

    public void makeDeviceSleep() {
        this.bleRequestList.addAll(this.bleAction.makeDeviceSleep());
        this.doAction();
    }

    public void enterDebug() {
        this.bleRequestList.addAll(this.bleAction.enterDebugMode());
        this.doAction();
    }

    public void quitDebug() {
        this.bleRequestList.addAll(this.bleAction.quitDebugMode());
        this.doAction();
    }

    public void triggerBeep() {
        this.bleRequestList.addAll(this.bleAction.triggerBeep());
        this.doAction();
    }

    public void doNextAction() {
        this.reDoActionCount = 0;
        this.curBleRequest = null;
        this.doAction();
    }

    public void reDoAction() {
        ++this.reDoActionCount;
        this.doAction();
    }

    private void doAction() {
        if (this.reDoActionCount > 0) {
            if (this.reDoActionCount >= 3) {
                this.clearRequest();
                this.response.refreshView(BleCallback.BleStatus.OPERATE_FAIL);
                Logger.w((String)"ble connect failed, over reDoAction times", (Object[])new Object[0]);
                return;
            }
            if (this.curBleRequest != null) {
                Logger.w((String)("ble reDoAction : " + this.curBleRequest.getCharacteristicUUID()), (Object[])new Object[0]);
                this.doInteractive(this.curBleRequest);
                return;
            }
        }
        if (this.curBleRequest != null) {
            return;
        }
        this.doInteractive(this.getAction());
    }

    private BleRequest getAction() {
        if (this.bleRequestList.size() > 0) {
            return this.bleRequestList.remove(0);
        }
        this.timeoutHandler.removeCallbacks(this.timeoutRunnable);
        return null;
    }

    private void doInteractive(BleRequest bleRequest) {
        this.curBleRequest = bleRequest;
        if (this.curBleRequest == null) {
            return;
        }
        boolean result = this.bleGattInteraction.doInteractive(this.bluetoothGatt, this.curBleRequest, this.characteristics, this.response);
        if (result) {
            return;
        }
        this.doNextAction();
    }

    public BleRequest getCurBleRequest() {
        return this.curBleRequest;
    }
}

