/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.android.thermometer.ble.action;

import android.bluetooth.BluetoothGattDescriptor;
import android.content.Context;
import cn.lollypop.android.thermometer.ble.action.IBleAction;
import cn.lollypop.android.thermometer.ble.action.request.AlarmReadRequest;
import cn.lollypop.android.thermometer.ble.action.request.AlarmWriteRequest;
import cn.lollypop.android.thermometer.ble.action.request.BatteryRequest;
import cn.lollypop.android.thermometer.ble.action.request.BleRequest;
import cn.lollypop.android.thermometer.ble.action.request.CurrentTimeReadRequest;
import cn.lollypop.android.thermometer.ble.action.request.CurrentTimeWriteRequest;
import cn.lollypop.android.thermometer.ble.action.request.CurrentVoltageRequest;
import cn.lollypop.android.thermometer.ble.action.request.DebugInfoRequest;
import cn.lollypop.android.thermometer.ble.action.request.EnterDebugModeRequest;
import cn.lollypop.android.thermometer.ble.action.request.HardwareRevisionRequest;
import cn.lollypop.android.thermometer.ble.action.request.IndoorTemperatureRequest;
import cn.lollypop.android.thermometer.ble.action.request.MakeDeviceSleepRequest;
import cn.lollypop.android.thermometer.ble.action.request.QuitDebugModeRequest;
import cn.lollypop.android.thermometer.ble.action.request.ReadDeviceTimeRequest;
import cn.lollypop.android.thermometer.ble.action.request.RefreshAlarmRequest;
import cn.lollypop.android.thermometer.ble.action.request.RefreshCurrentTimeRequest;
import cn.lollypop.android.thermometer.ble.action.request.RefreshCurrentVoltageRequest;
import cn.lollypop.android.thermometer.ble.action.request.RefreshDebugInfoRequest;
import cn.lollypop.android.thermometer.ble.action.request.RefreshIndoorTemperature;
import cn.lollypop.android.thermometer.ble.action.request.SNRevisionRequest;
import cn.lollypop.android.thermometer.ble.action.request.SampleIndicationRequest;
import cn.lollypop.android.thermometer.ble.action.request.SampleNotificationRequest;
import cn.lollypop.android.thermometer.ble.action.request.SoftwareRevisionRequest;
import cn.lollypop.android.thermometer.ble.action.request.TemperatureIndicationRequest;
import cn.lollypop.android.thermometer.ble.action.request.TemperatureIntervalRequest;
import cn.lollypop.android.thermometer.ble.action.request.TemperatureNotificationRequest;
import cn.lollypop.android.thermometer.ble.action.request.TriggerBeepRequest;
import cn.lollypop.android.thermometer.ble.model.AlarmTimeModel;
import cn.lollypop.android.thermometer.ble.utils.AlarmTimeServiceUtil;
import cn.lollypop.android.thermometer.ble.utils.DeviceInformationServiceUtil;
import com.basic.util.TimeUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class BleActionImpl
implements IBleAction {
    @Override
    public List<BleRequest> initConnect(Context context, boolean switchOriginalTemperature) {
        ArrayList<BleRequest> bleRequestList = new ArrayList<BleRequest>();
        bleRequestList.add(new SoftwareRevisionRequest());
        if (DeviceInformationServiceUtil.canGetSN(context)) {
            bleRequestList.add(new HardwareRevisionRequest());
            bleRequestList.add(new SNRevisionRequest());
        }
        bleRequestList.addAll(this.addUpdateTime());
        if (DeviceInformationServiceUtil.canOpenAlarm(context)) {
            bleRequestList.addAll(this.addAlarmAction(AlarmTimeModel.getSingle(context)));
        }
        if (DeviceInformationServiceUtil.canGetDebugInfo(context)) {
            bleRequestList.add(new RefreshDebugInfoRequest());
            bleRequestList.add(new DebugInfoRequest());
            bleRequestList.add(new RefreshCurrentVoltageRequest());
            bleRequestList.add(new CurrentVoltageRequest());
            bleRequestList.add(new RefreshIndoorTemperature());
            bleRequestList.add(new IndoorTemperatureRequest());
        }
        bleRequestList.add(new BatteryRequest());
        bleRequestList.addAll(this.addStartMeasureAction(switchOriginalTemperature));
        return bleRequestList;
    }

    @Override
    public List<BleRequest> setAlarm(AlarmTimeModel alarmTimeModel) {
        ArrayList<BleRequest> bleRequestList = new ArrayList<BleRequest>();
        bleRequestList.addAll(this.addAlarmAction(alarmTimeModel));
        return bleRequestList;
    }

    @Override
    public List<BleRequest> startMeasure(boolean switchOriginalTemperature) {
        ArrayList<BleRequest> bleRequestList = new ArrayList<BleRequest>();
        bleRequestList.addAll(this.addStartMeasureAction(switchOriginalTemperature));
        return bleRequestList;
    }

    @Override
    public List<BleRequest> getBatteryLevel() {
        ArrayList<BleRequest> bleRequestList = new ArrayList<BleRequest>();
        bleRequestList.add(new BatteryRequest());
        return bleRequestList;
    }

    @Override
    public List<BleRequest> doOta() {
        ArrayList<BleRequest> bleRequestList = new ArrayList<BleRequest>();
        bleRequestList.addAll(this.addEndSampleDataAction());
        bleRequestList.addAll(this.addEndMeasureAction());
        return bleRequestList;
    }

    @Override
    public List<BleRequest> makeDeviceSleep() {
        ArrayList<BleRequest> bleRequestList = new ArrayList<BleRequest>();
        bleRequestList.add(new MakeDeviceSleepRequest());
        return bleRequestList;
    }

    @Override
    public List<BleRequest> enterDebugMode() {
        ArrayList<BleRequest> bleRequestList = new ArrayList<BleRequest>();
        bleRequestList.add(new EnterDebugModeRequest());
        return bleRequestList;
    }

    @Override
    public List<BleRequest> quitDebugMode() {
        ArrayList<BleRequest> bleRequestList = new ArrayList<BleRequest>();
        bleRequestList.add(new QuitDebugModeRequest());
        return bleRequestList;
    }

    @Override
    public List<BleRequest> triggerBeep() {
        ArrayList<BleRequest> bleRequestList = new ArrayList<BleRequest>();
        bleRequestList.add(new TriggerBeepRequest());
        return bleRequestList;
    }

    protected List<BleRequest> addStartMeasureAction(boolean switchFlag) {
        ArrayList<BleRequest> bleRequestList = new ArrayList<BleRequest>();
        if (switchFlag) {
            bleRequestList.addAll(this.addStartSampleDataAction());
        }
        bleRequestList.add(new TemperatureNotificationRequest(true));
        bleRequestList.add(new TemperatureIndicationRequest(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE));
        bleRequestList.add(new TemperatureIntervalRequest(1, 0));
        return bleRequestList;
    }

    private List<BleRequest> addStartSampleDataAction() {
        ArrayList<BleRequest> bleRequestList = new ArrayList<BleRequest>();
        bleRequestList.add(new SampleNotificationRequest(true));
        bleRequestList.add(new SampleIndicationRequest(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE));
        return bleRequestList;
    }

    private List<BleRequest> addEndMeasureAction() {
        ArrayList<BleRequest> bleRequestList = new ArrayList<BleRequest>();
        bleRequestList.add(new TemperatureIntervalRequest(0, 0));
        bleRequestList.add(new TemperatureNotificationRequest(false));
        bleRequestList.add(new TemperatureIndicationRequest(BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE));
        return bleRequestList;
    }

    private List<BleRequest> addEndSampleDataAction() {
        ArrayList<BleRequest> bleRequestList = new ArrayList<BleRequest>();
        bleRequestList.add(new SampleNotificationRequest(false));
        bleRequestList.add(new SampleIndicationRequest(BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE));
        return bleRequestList;
    }

    protected List<BleRequest> addAlarmAction(AlarmTimeModel alarmTimeModel) {
        ArrayList<BleRequest> bleRequestList = new ArrayList<BleRequest>();
        byte[] value = AlarmTimeServiceUtil.generateSendData(alarmTimeModel);
        bleRequestList.add(new AlarmWriteRequest(value));
        bleRequestList.add(new RefreshAlarmRequest());
        bleRequestList.add(new AlarmReadRequest(value));
        return bleRequestList;
    }

    protected List<BleRequest> addUpdateTime() {
        ArrayList<BleRequest> bleRequestList = new ArrayList<BleRequest>();
        bleRequestList.add(new RefreshCurrentTimeRequest());
        bleRequestList.add(new ReadDeviceTimeRequest());
        int currentTime = TimeUtil.getTimestamp((long)Calendar.getInstance().getTimeInMillis());
        bleRequestList.add(new CurrentTimeWriteRequest(currentTime));
        bleRequestList.add(new RefreshCurrentTimeRequest());
        bleRequestList.add(new CurrentTimeReadRequest(currentTime));
        return bleRequestList;
    }
}

