/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.android.thermometer.ble;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import cn.lollypop.android.thermometer.ble.BleCallback;
import com.basic.thread.LollypopHandler;
import com.basic.thread.LollypopThreadPool;
import com.orhanobut.logger.Logger;
import java.util.ArrayList;
import java.util.List;

public class BleScan {
    private BleCallback scanCallback;
    private boolean isScanning;
    private BluetoothAdapter bluetoothAdapter;
    private static final int SCAN_TIMEOUT = 4000;
    private final Handler scanHandler = new Handler();
    private final LollypopHandler threadHandler;
    private ScanCallback bleScanCallback;
    private BluetoothDevice nearestDevice;
    private int lowestRSSI;
    private String deviceName;
    private final Runnable scanRunnable = new Runnable(){

        @Override
        public void run() {
            Logger.i((String)"ble scan timeout after 4 seconds", (Object[])new Object[0]);
            if (BleScan.this.nearestDevice != null) {
                Logger.i((String)("find device address : " + BleScan.this.nearestDevice.getAddress()), (Object[])new Object[0]);
                BleScan.this.stopScan();
                BleScan.this.scanCallback.callback(BleCallback.BleStatus.SCAN_SUC, BleScan.this.nearestDevice);
            } else if (BleScan.this.isScanning) {
                BleScan.this.scanHandler.postDelayed((Runnable)this, 4000L);
            } else {
                Logger.i((String)"scan failed", (Object[])new Object[0]);
                BleScan.this.scanHandler.removeCallbacks((Runnable)this);
                BleScan.this.scanCallback.callback(BleCallback.BleStatus.SCAN_FAIL, null);
            }
        }
    };
    private final BluetoothAdapter.LeScanCallback leScanCallback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            BleScan.this.handlerResult(device, rssi);
        }
    };

    public BleScan(BluetoothAdapter bluetoothAdapter, String deviceName) {
        this.bluetoothAdapter = bluetoothAdapter;
        this.deviceName = deviceName;
        this.threadHandler = LollypopThreadPool.getInstance().get("BLE_SCAN");
        if (Build.VERSION.SDK_INT >= 21) {
            this.bleScanCallback = new ScanCallback(){

                @TargetApi(value=21)
                public void onScanResult(int callbackType, ScanResult result) {
                    BleScan.this.handlerResult(result.getDevice(), result.getRssi());
                }

                @TargetApi(value=21)
                public void onBatchScanResults(List<ScanResult> results) {
                    for (ScanResult sr : results) {
                        Logger.i((String)("ScanResult - Results : " + sr.toString()), (Object[])new Object[0]);
                    }
                }

                public void onScanFailed(int errorCode) {
                    Logger.e((String)"Scan Failed", (Object[])new Object[]{"Error Code: " + errorCode});
                }
            };
        }
    }

    public void doScan(BleCallback scanCallback) {
        this.scanCallback = scanCallback;
        Logger.i((String)"begin scan ble ...", (Object[])new Object[0]);
        if (this.isScanning) {
            Logger.w((String)"it is scanning, directly return", (Object[])new Object[0]);
            return;
        }
        this.isScanning = true;
        this.lowestRSSI = -999;
        this.nearestDevice = null;
        this.scanHandler.postDelayed(this.scanRunnable, 4000L);
        this.threadHandler.post(new Runnable(){

            @Override
            public void run() {
                Logger.i((String)("SDK_INT = " + Build.VERSION.SDK_INT), (Object[])new Object[0]);
                if (Build.VERSION.SDK_INT >= 21) {
                    ScanSettings settings = new ScanSettings.Builder().setScanMode(2).build();
                    ArrayList filters = new ArrayList();
                    BleScan.this.bluetoothAdapter.getBluetoothLeScanner().startScan(filters, settings, BleScan.this.bleScanCallback);
                } else {
                    boolean b = BleScan.this.bluetoothAdapter.startLeScan(BleScan.this.leScanCallback);
                    Logger.i((String)("ble startScan \uff1a " + b), (Object[])new Object[0]);
                }
            }
        });
    }

    public void stopScan() {
        if (this.isScanning) {
            Logger.i((String)"ble stop scan", (Object[])new Object[0]);
            this.isScanning = false;
            this.threadHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (Build.VERSION.SDK_INT >= 21) {
                        if (BleScan.this.bluetoothAdapter == null || BleScan.this.bluetoothAdapter.getBluetoothLeScanner() == null) {
                            return;
                        }
                        BleScan.this.bluetoothAdapter.getBluetoothLeScanner().stopScan(BleScan.this.bleScanCallback);
                    } else {
                        BleScan.this.bluetoothAdapter.stopLeScan(BleScan.this.leScanCallback);
                    }
                }
            });
        }
    }

    private void handlerResult(BluetoothDevice device, int rssi) {
        if (!this.isScanning) {
            return;
        }
        Logger.i((String)("ble find devices : " + device.getName() + ", " + device.getAddress() + ", " + device.getType() + ", " + rssi), (Object[])new Object[0]);
        if (2 == device.getType() && !TextUtils.isEmpty((CharSequence)device.getName()) && device.getName().toUpperCase().contains(this.deviceName) && rssi > this.lowestRSSI) {
            this.lowestRSSI = rssi;
            this.nearestDevice = device;
        }
    }
}

