/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.android.thermometer.ble;

import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import cn.lollypop.android.thermometer.ble.BleAutoConnect;
import cn.lollypop.android.thermometer.ble.BleCallback;
import cn.lollypop.android.thermometer.ble.BleScan;
import cn.lollypop.android.thermometer.ble.Constants;
import cn.lollypop.android.thermometer.ble.action.BleActionImpl;
import cn.lollypop.android.thermometer.ble.action.BleActionManager;
import cn.lollypop.android.thermometer.ble.action.IBleAction;
import cn.lollypop.android.thermometer.ble.action.request.ReadDeviceTimeRequest;
import cn.lollypop.android.thermometer.ble.action.response.BleResponse;
import cn.lollypop.android.thermometer.ble.action.response.BleResponseType;
import cn.lollypop.android.thermometer.ble.exceptions.BleException;
import cn.lollypop.android.thermometer.ble.model.AlarmTimeModel;
import cn.lollypop.android.thermometer.ble.model.Temperature;
import cn.lollypop.android.thermometer.ble.ota.OtaManager;
import cn.lollypop.android.thermometer.ble.utils.BatteryServiceUtil;
import cn.lollypop.android.thermometer.ble.utils.DeviceInformationServiceUtil;
import cn.lollypop.android.thermometer.ble.utils.HealthThermometerServiceUtil;
import com.basic.util.Callback;
import com.basic.util.ClsUtil;
import com.basic.util.TimeUtil;
import com.orhanobut.logger.Logger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;

public class BleAutoConnectService
extends Service {
    private final BleAutoConnect bleAutoConnect = new BleAutoConnect();
    private final Handler connectTimeoutHandler = new Handler();
    private BleScan bleScan;
    private BleActionManager bleActionManager;
    private BluetoothAdapter bluetoothAdapter;
    private String deviceAddress;
    private boolean isConnected;
    private boolean originalTemperatureSwitcher = true;
    private final OtaManager otaManager = new OtaManager();
    private final Handler mainThreadHandler = new Handler();
    private final Object bleCallbackLock = new Object();
    private final List<BleCallback> bleCallbackList = new ArrayList<BleCallback>();
    private final IBinder binder = new LocalBinder();
    private BleAutoConnect.IChangeConnectState changeConnectState = new BleAutoConnect.IChangeConnectState(){

        @Override
        public void change(BleAutoConnect.ConnectState connectState) {
            switch (connectState) {
                case CONNECTED: {
                    Logger.i((String)"ble connect successfully and handle services", (Object[])new Object[0]);
                    BleAutoConnectService.this.isConnected = true;
                    BleAutoConnectService.this.doBleCallback(BleCallback.BleStatus.CONNECTED, BleAutoConnectService.this.deviceAddress);
                    BleAutoConnectService.this.bleActionManager.start(BleAutoConnectService.this.bleAutoConnect.getBluetoothGatt(), BleAutoConnectService.this.originalTemperatureSwitcher, new Callback(){

                        public void doCallback(Boolean result, Object obj) {
                            BleAutoConnectService.this.otaManager.initCharacteristic((BluetoothGattService)obj);
                        }
                    });
                    break;
                }
                case DIS_CONNECT: {
                    if (BleAutoConnectService.this.isConnected) {
                        Logger.i((String)"ble disconnect", (Object[])new Object[0]);
                    }
                    BleAutoConnectService.this.isConnected = false;
                    BleAutoConnectService.this.doBleCallback(BleCallback.BleStatus.DISCONNECTED, null);
                    BleAutoConnectService.this.bleActionManager.end();
                    break;
                }
            }
        }
    };
    private final BleAutoConnect.IResponse response = new BleAutoConnect.IResponse(){

        @Override
        public void receiveDataFromDevice(String action, BleResponse bleResponse) {
            String uuid = null;
            byte[] data = new byte[]{};
            if (bleResponse.getType().equals((Object)BleResponseType.CHARACTERISTIC)) {
                if (action.equals("cn.lollypop.android.thermometer.ble.ACTION_GATT_WRITE") ? BleAutoConnectService.this.otaManager.ackWrite(bleResponse.getCharacteristic(), bleResponse.getStatus()) : action.equals("cn.lollypop.android.thermometer.ble.ACTION_DATA_AVAILABLE") && BleAutoConnectService.this.otaManager.ackRead(bleResponse.getCharacteristic(), bleResponse.getStatus())) {
                    return;
                }
                data = bleResponse.getCharacteristic().getValue();
                uuid = bleResponse.getCharacteristic().getUuid().toString();
            } else if (bleResponse.getType().equals((Object)BleResponseType.DESCRIPTOR)) {
                data = bleResponse.getDescriptor().getValue();
                uuid = bleResponse.getDescriptor().getCharacteristic().getUuid().toString();
            }
            if (action.equals("cn.lollypop.android.thermometer.ble.ACTION_GATT_WRITE") || action.equals("cn.lollypop.android.thermometer.ble.ACTION_DATA_AVAILABLE")) {
                BleAutoConnectService.this.handleReceiveData(action, uuid, data);
            }
        }

        @Override
        public void refreshView(BleCallback.BleStatus bleState) {
            if (bleState.equals((Object)BleCallback.BleStatus.OPERATE_FAIL)) {
                BleAutoConnectService.this.reconnect();
            }
            BleAutoConnectService.this.doBleCallback(bleState, null);
        }
    };
    private final Runnable connectTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            if (BleAutoConnectService.this.otaManager.isTransferring()) {
                return;
            }
            if (BleAutoConnectService.this.isConnected()) {
                Logger.i((String)"ble make device go into sleep model", (Object[])new Object[0]);
                BleAutoConnectService.this.makeDeviceSleep();
            }
        }
    };

    @Nullable
    public IBinder onBind(Intent intent) {
        return this.binder;
    }

    public void onCreate() {
        super.onCreate();
        BluetoothManager bluetoothManager = (BluetoothManager)this.getSystemService("bluetooth");
        if (bluetoothManager == null) {
            Logger.i((String)"Unable to initialize BluetoothManager.", (Object[])new Object[0]);
            return;
        }
        this.bluetoothAdapter = bluetoothManager.getAdapter();
        if (this.bluetoothAdapter == null) {
            Logger.i((String)"Unable to obtain a BluetoothAdapter.", (Object[])new Object[0]);
            return;
        }
        this.bleActionManager = new BleActionManager((Context)this, this.response, this.createBleAction());
    }

    protected IBleAction createBleAction() {
        return new BleActionImpl();
    }

    public boolean startScan(String deviceName) {
        if (this.bluetoothAdapter == null) {
            Logger.i((String)"BluetoothAdapter is null", (Object[])new Object[0]);
            return false;
        }
        if (this.bleScan == null) {
            this.bleScan = new BleScan(this.bluetoothAdapter, deviceName);
        }
        this.bleScan.doScan(new BleCallback(){

            @Override
            public void callback(BleCallback.BleStatus state, Object object) {
                switch (state) {
                    case SCAN_SUC: {
                        BluetoothDevice device = (BluetoothDevice)object;
                        try {
                            BleAutoConnectService.this.connect(device.getAddress());
                        }
                        catch (BleException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                }
            }
        });
        return true;
    }

    public void stopScan() {
        if (this.bleScan == null) {
            return;
        }
        this.bleScan.stopScan();
    }

    public void connect(String address) throws BleException {
        if (TextUtils.isEmpty((CharSequence)address)) {
            throw new BleException("bluetooth address is null");
        }
        if (this.isConnected) {
            return;
        }
        boolean checkAddress = this.bleAutoConnect.connect((Context)this, this.bluetoothAdapter, address, this.changeConnectState, this.response);
        if (!checkAddress) {
            this.doBleCallback(BleCallback.BleStatus.DISCONNECTED, null);
        }
        this.deviceAddress = address;
    }

    public void destroy() {
        Logger.i((String)"ble connect destroyed", (Object[])new Object[0]);
        if (this.bleActionManager == null) {
            return;
        }
        this.stopScan();
        this.isConnected = false;
        this.deviceAddress = null;
        this.bleActionManager.end();
        this.bleAutoConnect.destroy();
        DeviceInformationServiceUtil.setFirmwareVersion((Context)this, "");
        BatteryServiceUtil.setBatteryLevel((Context)this, 0);
        DeviceInformationServiceUtil.setSN((Context)this, "");
        DeviceInformationServiceUtil.setHardwareVersion((Context)this, "");
    }

    public void reconnect() {
        this.bleAutoConnect.delayReconnect();
    }

    public void onDestroy() {
        super.onDestroy();
        this.destroy();
    }

    private void handleReceiveData(String action, String uuidStr, byte[] data) {
        UUID uuid = UUID.fromString(uuidStr);
        if (action.equals("cn.lollypop.android.thermometer.ble.ACTION_DATA_AVAILABLE")) {
            if (Constants.UUID_TEMPERATE_MEASUREMENT.equals(uuid)) {
                this.receiveTemperature(data);
                return;
            }
            if (Constants.UUID_SAMPLE_DATA.equals(uuid)) {
                this.receiveSampleData(data);
                return;
            }
        }
        if (this.bleActionManager.getCurBleRequest() == null) {
            return;
        }
        boolean analyze = this.bleActionManager.getCurBleRequest().analyzeData((Context)this, data);
        this.doBleCallback(this.bleActionManager.getCurBleRequest().getCurrentBleStatus(), this.bleActionManager.getCurBleRequest().getObject());
        if (!analyze) {
            this.bleActionManager.reDoAction();
            return;
        }
        this.bleActionManager.doNextAction();
    }

    protected void receiveTemperature(byte[] data) {
        int temperature = HealthThermometerServiceUtil.getValue(data);
        int calculateFlag = HealthThermometerServiceUtil.getCalculateFlag(data);
        int measureTimestamp = HealthThermometerServiceUtil.getTimestamp(data);
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        int currentTime = TimeUtil.getTimestamp((long)calendar.getTime().getTime());
        if (measureTimestamp < 1420041600 || measureTimestamp > currentTime) {
            measureTimestamp += ReadDeviceTimeRequest.deviceTimeOffset;
        }
        String content = String.format("ble receive data: %s, temperature: %d, time: %s", ClsUtil.Bytes2HexString((byte[])data), temperature, TimeUtil.getTimeInMillisShow((long)TimeUtil.getTimeInMillis((int)measureTimestamp)));
        Logger.i((String)content, (Object[])new Object[0]);
        Temperature temp = new Temperature();
        temp.setCalculateFlag(calculateFlag);
        temp.setTemperatureInt(temperature);
        temp.setMeasureTimestamp(measureTimestamp);
        this.doBleCallback(BleCallback.BleStatus.MEASURE_GET, temp);
    }

    private void receiveSampleData(byte[] data) {
        this.doBleCallback(BleCallback.BleStatus.MEASURE_SAMPLE_GET, data);
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setTimeout() {
        this.connectTimeoutHandler.postDelayed(this.connectTimeoutRunnable, 300000L);
        this.bleAutoConnect.removeReconnect();
    }

    public void clearTimeout() {
        if (!this.isConnected() && !TextUtils.isEmpty((CharSequence)this.deviceAddress)) {
            this.bleAutoConnect.delayReconnect();
        }
        this.connectTimeoutHandler.removeCallbacks(this.connectTimeoutRunnable);
    }

    public void setOriginalTemperatureSwitcher(boolean originalTemperatureSwitcher) {
        this.originalTemperatureSwitcher = originalTemperatureSwitcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBleCallback(BleCallback bleCallback) {
        Object object = this.bleCallbackLock;
        synchronized (object) {
            this.bleCallbackList.add(bleCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBleCallback(BleCallback bleCallback) {
        Object object = this.bleCallbackLock;
        synchronized (object) {
            for (BleCallback callback : this.bleCallbackList) {
                if (callback.hashCode() != bleCallback.hashCode()) continue;
                this.bleCallbackList.remove(callback);
                break;
            }
        }
    }

    protected void doBleCallback(final BleCallback.BleStatus bleState, final Object object) {
        if (bleState == null) {
            return;
        }
        this.mainThreadHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object2 = BleAutoConnectService.this.bleCallbackLock;
                synchronized (object2) {
                    for (BleCallback bleCallback : BleAutoConnectService.this.bleCallbackList) {
                        bleCallback.callback(bleState, object);
                    }
                }
            }
        });
    }

    public void startOta(String version) {
        this.otaManager.start((Context)this, version, this.bleAutoConnect.getBluetoothGatt(), new BleCallback(){

            @Override
            public void callback(BleCallback.BleStatus state, Object object) {
                BleAutoConnectService.this.doBleCallback(state, object);
            }
        });
    }

    public void makeDeviceSleep() {
        this.bleActionManager.makeDeviceSleep();
    }

    public void getBatteryLevel() {
        this.bleActionManager.getBatteryLevel();
    }

    public void triggerBeep() {
        this.bleActionManager.triggerBeep();
    }

    public void enterDebug() {
        this.bleActionManager.enterDebug();
    }

    public void quitDebug() {
        this.bleActionManager.quitDebug();
    }

    public void doOta() {
        this.bleActionManager.doOta();
    }

    public void startMeasure(boolean isSwitchOriginalTemperature) {
        this.bleActionManager.startMeasure(isSwitchOriginalTemperature);
    }

    public void setAlarm(AlarmTimeModel alarmTimeModel) {
        this.bleActionManager.setAlarm(alarmTimeModel);
    }

    public void refreshCache() {
        this.bleAutoConnect.refreshCache();
    }

    public class LocalBinder
    extends Binder {
        public BleAutoConnectService getService() {
            return BleAutoConnectService.this;
        }
    }
}

