/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.android.thermometer.ble;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import cn.lollypop.android.thermometer.ble.BleCallback;
import cn.lollypop.android.thermometer.ble.action.response.BleResponse;
import com.orhanobut.logger.Logger;
import java.lang.reflect.Method;

public class BleAutoConnect {
    private final Handler mainThreadHandler = new Handler();
    private final Object gattLock = new Object();
    private Context context;
    private BluetoothAdapter bluetoothAdapter;
    private BluetoothDevice device;
    protected BluetoothGatt bluetoothGatt;
    private IChangeConnectState changeConnectState;
    private IResponse response;
    private boolean autoConnect;
    private boolean isReconnecting;
    private final BroadcastReceiver blueStateBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int blueState = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
            switch (blueState) {
                case 10: {
                    Logger.i((String)"ble bleAutoConnect blueState: STATE_OFF", (Object[])new Object[0]);
                    BleAutoConnect.this.disconnect();
                    break;
                }
                case 11: {
                    break;
                }
                case 12: {
                    Logger.i((String)"ble bleAutoConnect blueState: STATE_ON", (Object[])new Object[0]);
                    BleAutoConnect.this.reconnect();
                    break;
                }
                case 13: {
                    break;
                }
            }
        }
    };
    private Runnable delayConnectRunnable = new Runnable(){

        @Override
        public void run() {
            if (BleAutoConnect.this.device == null) {
                return;
            }
            BluetoothManager bluetoothManager = (BluetoothManager)BleAutoConnect.this.context.getSystemService("bluetooth");
            int state = bluetoothManager.getConnectionState(BleAutoConnect.this.device, 7);
            if (state != 2) {
                BleAutoConnect.this.reconnect();
            }
        }
    };
    private Runnable connectRunnable = new Runnable(){

        @Override
        public void run() {
            BleAutoConnect.this.isReconnecting = false;
            if (BleAutoConnect.this.bluetoothGatt != null) {
                BleAutoConnect.this.bluetoothGatt.disconnect();
                BleAutoConnect.this.autoConnect = BleAutoConnect.this.bluetoothGatt.connect();
                Logger.d((Object)("ble autoConnect : " + BleAutoConnect.this.autoConnect));
                return;
            }
            BleAutoConnect.this.reconnect();
        }
    };
    protected final BluetoothGattCallback gattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            if (newState == 1 || newState == 3) {
                Logger.i((String)("ble connection state change, new state : " + newState), (Object[])new Object[0]);
                return;
            }
            BleAutoConnect.this.isReconnecting = false;
            if (newState == 2 && status == 0) {
                Logger.i((String)("ble begin discoverServices, new state : " + newState), (Object[])new Object[0]);
                BleAutoConnect.this.bluetoothGatt.discoverServices();
                BleAutoConnect.this.mainThreadHandler.removeCallbacks(BleAutoConnect.this.connectRunnable);
                BleAutoConnect.this.removeReconnect();
            } else {
                Logger.e((String)("ble connection state change, new state : " + newState), (Object[])new Object[0]);
                BleAutoConnect.this.changeConnectState.change(ConnectState.DIS_CONNECT);
                if (!BleAutoConnect.this.autoConnect) {
                    BleAutoConnect.this.mainThreadHandler.postDelayed(BleAutoConnect.this.connectRunnable, 2000L);
                }
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, final int status) {
            BleAutoConnect.this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (status == 0) {
                        Logger.i((String)"ble services discovered success", (Object[])new Object[0]);
                        BleAutoConnect.this.changeConnectState.change(ConnectState.CONNECTED);
                        BleAutoConnect.this.removeReconnect();
                    } else {
                        Logger.e((String)("ble services discovered error status : " + status), (Object[])new Object[0]);
                        BleAutoConnect.this.reconnect();
                    }
                }
            });
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic charact, int status) {
            BleResponse bleResponse = new BleResponse(charact, status);
            BleAutoConnect.this.response.receiveDataFromDevice("cn.lollypop.android.thermometer.ble.ACTION_DATA_AVAILABLE", bleResponse);
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic c) {
            BleResponse bleResponse = new BleResponse(c, 0);
            BleAutoConnect.this.response.receiveDataFromDevice("cn.lollypop.android.thermometer.ble.ACTION_DATA_AVAILABLE", bleResponse);
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic c, int status) {
            BleResponse bleResponse = new BleResponse(c, status);
            BleAutoConnect.this.response.receiveDataFromDevice("cn.lollypop.android.thermometer.ble.ACTION_GATT_WRITE", bleResponse);
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            BleResponse bleResponse = new BleResponse(descriptor, status);
            BleAutoConnect.this.response.receiveDataFromDevice("cn.lollypop.android.thermometer.ble.ACTION_GATT_WRITE", bleResponse);
        }
    };

    public boolean connect(Context context, BluetoothAdapter bluetoothAdapter, String deviceAddress, IChangeConnectState changeConnectState, IResponse response) {
        this.context = context;
        this.bluetoothAdapter = bluetoothAdapter;
        this.changeConnectState = changeConnectState;
        this.response = response;
        if (!BluetoothAdapter.checkBluetoothAddress((String)deviceAddress)) {
            Logger.e((String)("ble connect with wrong address\uff1a" + deviceAddress), (Object[])new Object[0]);
            return false;
        }
        this.device = bluetoothAdapter.getRemoteDevice(deviceAddress);
        context.registerReceiver(this.blueStateBroadcastReceiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
        return this.reconnect();
    }

    public void delayReconnect() {
        this.mainThreadHandler.postDelayed(this.delayConnectRunnable, 2000L);
    }

    public void removeReconnect() {
        this.mainThreadHandler.removeCallbacks(this.delayConnectRunnable);
    }

    private boolean reconnect() {
        Logger.d((Object)("ble isReconnecting : " + this.isReconnecting));
        if (!this.bluetoothAdapter.isEnabled()) {
            return false;
        }
        if (this.device == null) {
            return false;
        }
        if (this.isReconnecting) {
            return true;
        }
        this.isReconnecting = true;
        this.disconnect();
        this.mainThreadHandler.postDelayed(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = BleAutoConnect.this.gattLock;
                synchronized (object) {
                    if (!BleAutoConnect.this.bluetoothAdapter.isEnabled() || BleAutoConnect.this.device == null) {
                        return;
                    }
                    Logger.i((String)"ble begin connect gatt", (Object[])new Object[0]);
                    BleAutoConnect.this.bluetoothGatt = Build.VERSION.SDK_INT >= 23 ? BleAutoConnect.this.device.connectGatt(BleAutoConnect.this.context, false, BleAutoConnect.this.gattCallback, 2) : BleAutoConnect.this.device.connectGatt(BleAutoConnect.this.context, false, BleAutoConnect.this.gattCallback);
                    BleAutoConnect.this.mainThreadHandler.postDelayed(BleAutoConnect.this.connectRunnable, 20000L);
                }
            }
        }, 2000L);
        return true;
    }

    public void refreshCache() {
        if (this.bluetoothGatt != null) {
            this.refreshDeviceCache(this.bluetoothGatt);
        }
    }

    public void destroy() {
        if (this.context != null && this.device != null) {
            this.context.unregisterReceiver(this.blueStateBroadcastReceiver);
        }
        this.device = null;
        this.isReconnecting = false;
        this.disconnect();
    }

    private void disconnect() {
        this.mainThreadHandler.removeCallbacks(this.connectRunnable);
        this.removeReconnect();
        this.mainThreadHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = BleAutoConnect.this.gattLock;
                synchronized (object) {
                    if (BleAutoConnect.this.bluetoothGatt == null) {
                        return;
                    }
                    BleAutoConnect.this.bluetoothGatt.disconnect();
                    BleAutoConnect.this.refreshDeviceCache(BleAutoConnect.this.bluetoothGatt);
                    BleAutoConnect.this.bluetoothGatt.close();
                    BleAutoConnect.this.bluetoothGatt = null;
                    BleAutoConnect.this.autoConnect = false;
                }
            }
        });
    }

    private boolean refreshDeviceCache(BluetoothGatt gatt) {
        try {
            Method localMethod = gatt.getClass().getMethod("refresh", new Class[0]);
            if (localMethod != null) {
                return (Boolean)localMethod.invoke((Object)gatt, new Object[0]);
            }
        }
        catch (Exception localException) {
            Logger.e((String)"ble An exception occurs while refreshing device", (Object[])new Object[0]);
        }
        return false;
    }

    public BluetoothGatt getBluetoothGatt() {
        return this.bluetoothGatt;
    }

    public static interface IResponse {
        public void receiveDataFromDevice(String var1, BleResponse var2);

        public void refreshView(BleCallback.BleStatus var1);
    }

    public static interface IChangeConnectState {
        public void change(ConnectState var1);
    }

    public static enum ConnectState {
        CONNECTED,
        DIS_CONNECT;

    }
}

