package cn.lollypop.android.thermometer.ble.utils;

import android.content.Context;
import android.text.TextUtils;
import com.basic.util.ACache;

public class DeviceInformationServiceUtil {

  public static String getSoftwareRevision(byte[] value) {
    if (value == null) {
      return "0.0.0";
    }
    return new String(value);
  }

  public static void setFirmwareVersion(Context context, String version) {
    ACache.get(context).put("FirmwareVersion", version);
  }

  public static String getFirmwareVersion(Context context) {
    String version = ACache.get(context).getAsString("FirmwareVersion");
    if (TextUtils.isEmpty(version)) {
      return "0.0.0";
    } else {
      return version;
    }
  }

  public static String getHardwareRevision(byte[] value) {
    if (value == null) {
      return "";
    }
    return new String(value);
  }

  public static void setHardwareVersion(Context context, String version) {
    ACache.get(context).put("HardwareVersion", version);
  }

  public static String getHardwareVersion(Context context) {
    return ACache.get(context).getAsString("HardwareVersion");
  }

  public static String getSNRevision(byte[] value) {
    if (value == null) {
      return "";
    }
    return new String(value);
  }

  public static void setSN(Context context, String sn) {
    ACache.get(context).put("sn", sn);
  }

  public static String getSN(Context context) {
    return ACache.get(context).getAsString("sn");
  }

  public static boolean canGetSN(Context context) {
    String softwareRevision =
        DeviceInformationServiceUtil.getFirmwareVersion(context);
    if (!TextUtils.isEmpty(softwareRevision)) {
      String[] s = softwareRevision.split("\\.");
      if (s.length >= 3) { //1.1.0
        try {
          int major = Integer.parseInt(s[0]);
          if (major >= 2) {
            return true;
          }
        } catch (Exception e) {
          return false;
        }
      }
    }
    return false;
  }

  /**
   * 是否需要OTA，assets下有IMG文件，版本号不同，才需要ota.
   *
   * @return true 需要OTA， false 不需要ota
   */
  public static boolean needOta(Context context,
                                String serverVersion,
                                boolean needOTA) {
    if (TextUtils.isEmpty(serverVersion)) {
      return false;
    }

    if (!needOTA) {
      return false;
    }

    String deviceFirmwareRevision =
        DeviceInformationServiceUtil.getFirmwareVersion(context);
    if (!TextUtils.isEmpty(deviceFirmwareRevision)) {
      deviceFirmwareRevision = deviceFirmwareRevision.toLowerCase();
      String[] deviceFirmwareRevisions = deviceFirmwareRevision.split("\\.");
      String[] serverFirmwareVersions = serverVersion.split("\\.");
      if (deviceFirmwareRevisions.length >= 3
          && serverFirmwareVersions.length >= 3) { //1.1.0
        try {
          int deviceFirmwareRevisionMajor =
              Integer.parseInt(deviceFirmwareRevisions[0]);
          int deviceFirmwareRevisionMinor =
              Integer.parseInt(deviceFirmwareRevisions[1]);
          int deviceFirmwareRevisionBugFix =
              Integer.parseInt(deviceFirmwareRevisions[2]);
          int serverFirmwareVersionMajor =
              Integer.parseInt(serverFirmwareVersions[0]);
          int serverFirmwareVersionMinor =
              Integer.parseInt(serverFirmwareVersions[1]);
          int serverFirmwareVersionBugFix =
              Integer.parseInt(serverFirmwareVersions[2]);
          if (serverFirmwareVersionMajor == deviceFirmwareRevisionMajor) {
            if (serverFirmwareVersionMinor > deviceFirmwareRevisionMinor ||
                (serverFirmwareVersionMinor == deviceFirmwareRevisionMinor
                    && serverFirmwareVersionBugFix
                    > deviceFirmwareRevisionBugFix)) {
              return true;
            }
          }
        } catch (Exception e) { //之前的版本有V_开头，直接升级
          return true;
        }
      }
      return false;
    }
    return false;
  }

  /**
   * 1.1.0之后的版本才开启闹钟.
   *
   * @return true 可以打开闹钟
   */
  public static boolean canOpenAlarm(Context context) {
    String softwareRevision =
        DeviceInformationServiceUtil.getFirmwareVersion(context);
    if (!TextUtils.isEmpty(softwareRevision)) {
      String[] s = softwareRevision.split("\\.");
      if (s.length >= 3) { //1.1.0
        try {
          int major = Integer.parseInt(s[0]);
          int minor = Integer.parseInt(s[1]);
          if (major > 1 || minor >= 1) {
            return true;
          }
        } catch (Exception e) {
          return false;
        }
      }
    }
    return false;
  }

  /**
   * 3.1.3之后才可以获取debug信息.
   *
   * @param context context
   * @return boolean
   */
  public static boolean canGetDebugInfo(Context context) {
    String softwareRevision =
        DeviceInformationServiceUtil.getFirmwareVersion(context);
    if (!TextUtils.isEmpty(softwareRevision)) {
      String[] s = softwareRevision.split("\\.");
      if (s.length >= 3) { //*.*.*
        try {
          int major = Integer.parseInt(s[0]);
          int minor = Integer.parseInt(s[1]);
          int bugFix = Integer.parseInt(s[2]);
          if (major > 3) {
            return true;
          } else if (major == 3) {
            if (minor > 1) {
              return true;
            } else if (minor == 1) {
              if (bugFix >= 3) {
                return true;
              }
            }
          }
        } catch (Exception e) {
          return false;
        }
      }
    }
    return false;
  }
}
